package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IntentOverride(
    name: Optional[Name] = Optional.Absent,
    slots: Optional[Map[Name, zio.aws.lexmodelsv2.model.SlotValueOverride]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentOverride = {
    import IntentOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentOverride
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        slots.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.slots)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.IntentOverride.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentOverride.wrap(buildAwsValue())
}
object IntentOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.IntentOverride =
      zio.aws.lexmodelsv2.model.IntentOverride(
        name.map(value => value),
        slots.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def name: Optional[Name]
    def slots: Optional[
      Map[Name, zio.aws.lexmodelsv2.model.SlotValueOverride.ReadOnly]
    ]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSlots: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.lexmodelsv2.model.SlotValueOverride.ReadOnly
    ]] = AwsError.unwrapOptionField("slots", slots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentOverride
  ) extends zio.aws.lexmodelsv2.model.IntentOverride.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val slots: Optional[
      Map[Name, zio.aws.lexmodelsv2.model.SlotValueOverride.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.slots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.Name(
              key
            ) -> zio.aws.lexmodelsv2.model.SlotValueOverride.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentOverride
  ): zio.aws.lexmodelsv2.model.IntentOverride.ReadOnly = new Wrapper(impl)
}
