package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{ButtonValue, ButtonText}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Button(text: ButtonText, value: ButtonValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.Button = {
    import Button.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.Button
      .builder()
      .text(ButtonText.unwrap(text): java.lang.String)
      .value(ButtonValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.Button.ReadOnly =
    zio.aws.lexmodelsv2.model.Button.wrap(buildAwsValue())
}
object Button {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.Button
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.Button =
      zio.aws.lexmodelsv2.model.Button(text, value)
    def text: ButtonText
    def value: ButtonValue
    def getText: ZIO[Any, Nothing, ButtonText] = ZIO.succeed(text)
    def getValue: ZIO[Any, Nothing, ButtonValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.Button
  ) extends zio.aws.lexmodelsv2.model.Button.ReadOnly {
    override val text: ButtonText =
      zio.aws.lexmodelsv2.model.primitives.ButtonText(impl.text())
    override val value: ButtonValue =
      zio.aws.lexmodelsv2.model.primitives.ButtonValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.Button
  ): zio.aws.lexmodelsv2.model.Button.ReadOnly = new Wrapper(impl)
}
