package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AudioLogDestination(
    s3Bucket: zio.aws.lexmodelsv2.model.S3BucketLogDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AudioLogDestination = {
    import AudioLogDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AudioLogDestination
      .builder()
      .s3Bucket(s3Bucket.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AudioLogDestination.ReadOnly =
    zio.aws.lexmodelsv2.model.AudioLogDestination.wrap(buildAwsValue())
}
object AudioLogDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AudioLogDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AudioLogDestination =
      zio.aws.lexmodelsv2.model.AudioLogDestination(s3Bucket.asEditable)
    def s3Bucket: zio.aws.lexmodelsv2.model.S3BucketLogDestination.ReadOnly
    def getS3Bucket: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.S3BucketLogDestination.ReadOnly
    ] = ZIO.succeed(s3Bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AudioLogDestination
  ) extends zio.aws.lexmodelsv2.model.AudioLogDestination.ReadOnly {
    override val s3Bucket
        : zio.aws.lexmodelsv2.model.S3BucketLogDestination.ReadOnly =
      zio.aws.lexmodelsv2.model.S3BucketLogDestination.wrap(impl.s3Bucket())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AudioLogDestination
  ): zio.aws.lexmodelsv2.model.AudioLogDestination.ReadOnly = new Wrapper(impl)
}
