package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  Timestamp,
  DraftBotVersion,
  Description,
  Name,
  BuiltInOrCustomSlotTypeId,
  Id
}
import scala.jdk.CollectionConverters.*
final case class UpdateSlotResponse(
    slotId: Optional[Id] = Optional.Absent,
    slotName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    slotTypeId: Optional[BuiltInOrCustomSlotTypeId] = Optional.Absent,
    valueElicitationSetting: Optional[
      zio.aws.lexmodelsv2.model.SlotValueElicitationSetting
    ] = Optional.Absent,
    obfuscationSetting: Optional[zio.aws.lexmodelsv2.model.ObfuscationSetting] =
      Optional.Absent,
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[DraftBotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    intentId: Optional[Id] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent,
    multipleValuesSetting: Optional[
      zio.aws.lexmodelsv2.model.MultipleValuesSetting
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotResponse = {
    import UpdateSlotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotResponse
      .builder()
      .optionallyWith(slotId.map(value => Id.unwrap(value): java.lang.String))(
        _.slotId
      )
      .optionallyWith(
        slotName.map(value => Name.unwrap(value): java.lang.String)
      )(_.slotName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        slotTypeId.map(value =>
          BuiltInOrCustomSlotTypeId.unwrap(value): java.lang.String
        )
      )(_.slotTypeId)
      .optionallyWith(
        valueElicitationSetting.map(value => value.buildAwsValue())
      )(_.valueElicitationSetting)
      .optionallyWith(obfuscationSetting.map(value => value.buildAwsValue()))(
        _.obfuscationSetting
      )
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        intentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.intentId)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        multipleValuesSetting.map(value => value.buildAwsValue())
      )(_.multipleValuesSetting)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateSlotResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateSlotResponse.wrap(buildAwsValue())
}
object UpdateSlotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateSlotResponse =
      zio.aws.lexmodelsv2.model.UpdateSlotResponse(
        slotId.map(value => value),
        slotName.map(value => value),
        description.map(value => value),
        slotTypeId.map(value => value),
        valueElicitationSetting.map(value => value.asEditable),
        obfuscationSetting.map(value => value.asEditable),
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        intentId.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        multipleValuesSetting.map(value => value.asEditable)
      )
    def slotId: Optional[Id]
    def slotName: Optional[Name]
    def description: Optional[Description]
    def slotTypeId: Optional[BuiltInOrCustomSlotTypeId]
    def valueElicitationSetting: Optional[
      zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly
    ]
    def obfuscationSetting
        : Optional[zio.aws.lexmodelsv2.model.ObfuscationSetting.ReadOnly]
    def botId: Optional[Id]
    def botVersion: Optional[DraftBotVersion]
    def localeId: Optional[LocaleId]
    def intentId: Optional[Id]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def multipleValuesSetting
        : Optional[zio.aws.lexmodelsv2.model.MultipleValuesSetting.ReadOnly]
    def getSlotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("slotId", slotId)
    def getSlotName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("slotName", slotName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSlotTypeId: ZIO[Any, AwsError, BuiltInOrCustomSlotTypeId] =
      AwsError.unwrapOptionField("slotTypeId", slotTypeId)
    def getValueElicitationSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly
    ] = AwsError.unwrapOptionField(
      "valueElicitationSetting",
      valueElicitationSetting
    )
    def getObfuscationSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ObfuscationSetting.ReadOnly
    ] = AwsError.unwrapOptionField("obfuscationSetting", obfuscationSetting)
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getIntentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("intentId", intentId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getMultipleValuesSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.MultipleValuesSetting.ReadOnly
    ] =
      AwsError.unwrapOptionField("multipleValuesSetting", multipleValuesSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotResponse
  ) extends zio.aws.lexmodelsv2.model.UpdateSlotResponse.ReadOnly {
    override val slotId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.slotId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val slotName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.slotName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val slotTypeId: Optional[BuiltInOrCustomSlotTypeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slotTypeId())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.BuiltInOrCustomSlotTypeId(value)
        )
    override val valueElicitationSetting: Optional[
      zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.valueElicitationSetting())
      .map(value =>
        zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.wrap(value)
      )
    override val obfuscationSetting
        : Optional[zio.aws.lexmodelsv2.model.ObfuscationSetting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.obfuscationSetting())
        .map(value => zio.aws.lexmodelsv2.model.ObfuscationSetting.wrap(value))
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[DraftBotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val intentId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.intentId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val multipleValuesSetting
        : Optional[zio.aws.lexmodelsv2.model.MultipleValuesSetting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multipleValuesSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.MultipleValuesSetting.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotResponse
  ): zio.aws.lexmodelsv2.model.UpdateSlotResponse.ReadOnly = new Wrapper(impl)
}
