package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{RevisionId, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateResourcePolicyResponse(
    resourceArn: Optional[AmazonResourceName] = Optional.Absent,
    revisionId: Optional[RevisionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyResponse = {
    import UpdateResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyResponse
      .builder()
      .optionallyWith(
        resourceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.resourceArn)
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.UpdateResourcePolicyResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateResourcePolicyResponse.wrap(buildAwsValue())
}
object UpdateResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateResourcePolicyResponse =
      zio.aws.lexmodelsv2.model.UpdateResourcePolicyResponse(
        resourceArn.map(value => value),
        revisionId.map(value => value)
      )
    def resourceArn: Optional[AmazonResourceName]
    def revisionId: Optional[RevisionId]
    def getResourceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyResponse
  ) extends zio.aws.lexmodelsv2.model.UpdateResourcePolicyResponse.ReadOnly {
    override val resourceArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceArn())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.AmazonResourceName(value)
        )
    override val revisionId: Optional[RevisionId] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.RevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyResponse
  ): zio.aws.lexmodelsv2.model.UpdateResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
