package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  Name,
  ImportedResourceId,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ImportSummary(
    importId: Option[Id] = None,
    importedResourceId: Option[ImportedResourceId] = None,
    importedResourceName: Option[Name] = None,
    importStatus: Option[zio.aws.lexmodelsv2.model.ImportStatus] = None,
    mergeStrategy: Option[zio.aws.lexmodelsv2.model.MergeStrategy] = None,
    creationDateTime: Option[Timestamp] = None,
    lastUpdatedDateTime: Option[Timestamp] = None,
    importedResourceType: Option[zio.aws.lexmodelsv2.model.ImportResourceType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary = {
    import ImportSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary
      .builder()
      .optionallyWith(
        importId.map(value => Id.unwrap(value): java.lang.String)
      )(_.importId)
      .optionallyWith(
        importedResourceId.map(value =>
          ImportedResourceId.unwrap(value): java.lang.String
        )
      )(_.importedResourceId)
      .optionallyWith(
        importedResourceName.map(value => Name.unwrap(value): java.lang.String)
      )(_.importedResourceName)
      .optionallyWith(importStatus.map(value => value.unwrap))(_.importStatus)
      .optionallyWith(mergeStrategy.map(value => value.unwrap))(_.mergeStrategy)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(importedResourceType.map(value => value.unwrap))(
        _.importedResourceType
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ImportSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.ImportSummary.wrap(buildAwsValue())
}
object ImportSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ImportSummary =
      zio.aws.lexmodelsv2.model.ImportSummary(
        importId.map(value => value),
        importedResourceId.map(value => value),
        importedResourceName.map(value => value),
        importStatus.map(value => value),
        mergeStrategy.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        importedResourceType.map(value => value)
      )
    def importId: Option[Id]
    def importedResourceId: Option[ImportedResourceId]
    def importedResourceName: Option[Name]
    def importStatus: Option[zio.aws.lexmodelsv2.model.ImportStatus]
    def mergeStrategy: Option[zio.aws.lexmodelsv2.model.MergeStrategy]
    def creationDateTime: Option[Timestamp]
    def lastUpdatedDateTime: Option[Timestamp]
    def importedResourceType
        : Option[zio.aws.lexmodelsv2.model.ImportResourceType]
    def getImportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("importId", importId)
    def getImportedResourceId: ZIO[Any, AwsError, ImportedResourceId] =
      AwsError.unwrapOptionField("importedResourceId", importedResourceId)
    def getImportedResourceName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("importedResourceName", importedResourceName)
    def getImportStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ImportStatus] =
      AwsError.unwrapOptionField("importStatus", importStatus)
    def getMergeStrategy
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.MergeStrategy] =
      AwsError.unwrapOptionField("mergeStrategy", mergeStrategy)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getImportedResourceType
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ImportResourceType] =
      AwsError.unwrapOptionField("importedResourceType", importedResourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary
  ) extends zio.aws.lexmodelsv2.model.ImportSummary.ReadOnly {
    override val importId: Option[Id] = scala
      .Option(impl.importId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val importedResourceId: Option[ImportedResourceId] = scala
      .Option(impl.importedResourceId())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.ImportedResourceId(value)
      )
    override val importedResourceName: Option[Name] = scala
      .Option(impl.importedResourceName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val importStatus: Option[zio.aws.lexmodelsv2.model.ImportStatus] =
      scala
        .Option(impl.importStatus())
        .map(value => zio.aws.lexmodelsv2.model.ImportStatus.wrap(value))
    override val mergeStrategy
        : Option[zio.aws.lexmodelsv2.model.MergeStrategy] = scala
      .Option(impl.mergeStrategy())
      .map(value => zio.aws.lexmodelsv2.model.MergeStrategy.wrap(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val importedResourceType
        : Option[zio.aws.lexmodelsv2.model.ImportResourceType] = scala
      .Option(impl.importedResourceType())
      .map(value => zio.aws.lexmodelsv2.model.ImportResourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary
  ): zio.aws.lexmodelsv2.model.ImportSummary.ReadOnly = new Wrapper(impl)
}
