package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  BoxedBoolean,
  FulfillmentStartResponseDelay
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FulfillmentStartResponseSpecification(
    delayInSeconds: FulfillmentStartResponseDelay,
    messageGroups: Iterable[zio.aws.lexmodelsv2.model.MessageGroup],
    allowInterrupt: Option[BoxedBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentStartResponseSpecification = {
    import FulfillmentStartResponseSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentStartResponseSpecification
      .builder()
      .delayInSeconds(
        FulfillmentStartResponseDelay.unwrap(delayInSeconds): Integer
      )
      .messageGroups(messageGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(allowInterrupt.map(value => value: java.lang.Boolean))(
        _.allowInterrupt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.FulfillmentStartResponseSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.FulfillmentStartResponseSpecification
      .wrap(buildAwsValue())
}
object FulfillmentStartResponseSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentStartResponseSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.FulfillmentStartResponseSpecification =
      zio.aws.lexmodelsv2.model.FulfillmentStartResponseSpecification(
        delayInSeconds,
        messageGroups.map { item =>
          item.asEditable
        },
        allowInterrupt.map(value => value)
      )
    def delayInSeconds: FulfillmentStartResponseDelay
    def messageGroups: List[zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly]
    def allowInterrupt: Option[BoxedBoolean]
    def getDelayInSeconds: ZIO[Any, Nothing, FulfillmentStartResponseDelay] =
      ZIO.succeed(delayInSeconds)
    def getMessageGroups: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly
    ]] = ZIO.succeed(messageGroups)
    def getAllowInterrupt: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("allowInterrupt", allowInterrupt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentStartResponseSpecification
  ) extends zio.aws.lexmodelsv2.model.FulfillmentStartResponseSpecification.ReadOnly {
    override val delayInSeconds: FulfillmentStartResponseDelay =
      zio.aws.lexmodelsv2.model.primitives
        .FulfillmentStartResponseDelay(impl.delayInSeconds())
    override val messageGroups
        : List[zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly] = impl
      .messageGroups()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.MessageGroup.wrap(item)
      }
      .toList
    override val allowInterrupt: Option[BoxedBoolean] =
      scala.Option(impl.allowInterrupt()).map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentStartResponseSpecification
  ): zio.aws.lexmodelsv2.model.FulfillmentStartResponseSpecification.ReadOnly =
    new Wrapper(impl)
}
