package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  BoxedBoolean,
  StillWaitingResponseTimeout,
  StillWaitingResponseFrequency
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StillWaitingResponseSpecification(
    messageGroups: Iterable[zio.aws.lexmodelsv2.model.MessageGroup],
    frequencyInSeconds: StillWaitingResponseFrequency,
    timeoutInSeconds: StillWaitingResponseTimeout,
    allowInterrupt: Option[BoxedBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.StillWaitingResponseSpecification = {
    import StillWaitingResponseSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.StillWaitingResponseSpecification
      .builder()
      .messageGroups(messageGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .frequencyInSeconds(
        StillWaitingResponseFrequency.unwrap(frequencyInSeconds): Integer
      )
      .timeoutInSeconds(
        StillWaitingResponseTimeout.unwrap(timeoutInSeconds): Integer
      )
      .optionallyWith(allowInterrupt.map(value => value: java.lang.Boolean))(
        _.allowInterrupt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.StillWaitingResponseSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.StillWaitingResponseSpecification
      .wrap(buildAwsValue())
}
object StillWaitingResponseSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.StillWaitingResponseSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.StillWaitingResponseSpecification =
      zio.aws.lexmodelsv2.model.StillWaitingResponseSpecification(
        messageGroups.map { item =>
          item.asEditable
        },
        frequencyInSeconds,
        timeoutInSeconds,
        allowInterrupt.map(value => value)
      )
    def messageGroups: List[zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly]
    def frequencyInSeconds: StillWaitingResponseFrequency
    def timeoutInSeconds: StillWaitingResponseTimeout
    def allowInterrupt: Option[BoxedBoolean]
    def getMessageGroups: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly
    ]] = ZIO.succeed(messageGroups)
    def getFrequencyInSeconds
        : ZIO[Any, Nothing, StillWaitingResponseFrequency] =
      ZIO.succeed(frequencyInSeconds)
    def getTimeoutInSeconds: ZIO[Any, Nothing, StillWaitingResponseTimeout] =
      ZIO.succeed(timeoutInSeconds)
    def getAllowInterrupt: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("allowInterrupt", allowInterrupt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StillWaitingResponseSpecification
  ) extends zio.aws.lexmodelsv2.model.StillWaitingResponseSpecification.ReadOnly {
    override val messageGroups
        : List[zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly] = impl
      .messageGroups()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.MessageGroup.wrap(item)
      }
      .toList
    override val frequencyInSeconds: StillWaitingResponseFrequency =
      zio.aws.lexmodelsv2.model.primitives
        .StillWaitingResponseFrequency(impl.frequencyInSeconds())
    override val timeoutInSeconds: StillWaitingResponseTimeout =
      zio.aws.lexmodelsv2.model.primitives
        .StillWaitingResponseTimeout(impl.timeoutInSeconds())
    override val allowInterrupt: Option[BoxedBoolean] =
      scala.Option(impl.allowInterrupt()).map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StillWaitingResponseSpecification
  ): zio.aws.lexmodelsv2.model.StillWaitingResponseSpecification.ReadOnly =
    new Wrapper(impl)
}
