package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SlotValueElicitationSetting(
    defaultValueSpecification: Option[
      zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification
    ] = None,
    slotConstraint: zio.aws.lexmodelsv2.model.SlotConstraint,
    promptSpecification: Option[zio.aws.lexmodelsv2.model.PromptSpecification] =
      None,
    sampleUtterances: Option[
      Iterable[zio.aws.lexmodelsv2.model.SampleUtterance]
    ] = None,
    waitAndContinueSpecification: Option[
      zio.aws.lexmodelsv2.model.WaitAndContinueSpecification
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotValueElicitationSetting = {
    import SlotValueElicitationSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotValueElicitationSetting
      .builder()
      .optionallyWith(
        defaultValueSpecification.map(value => value.buildAwsValue())
      )(_.defaultValueSpecification)
      .slotConstraint(slotConstraint.unwrap)
      .optionallyWith(promptSpecification.map(value => value.buildAwsValue()))(
        _.promptSpecification
      )
      .optionallyWith(
        sampleUtterances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sampleUtterances)
      .optionallyWith(
        waitAndContinueSpecification.map(value => value.buildAwsValue())
      )(_.waitAndContinueSpecification)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.wrap(buildAwsValue())
}
object SlotValueElicitationSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotValueElicitationSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotValueElicitationSetting =
      zio.aws.lexmodelsv2.model.SlotValueElicitationSetting(
        defaultValueSpecification.map(value => value.asEditable),
        slotConstraint,
        promptSpecification.map(value => value.asEditable),
        sampleUtterances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        waitAndContinueSpecification.map(value => value.asEditable)
      )
    def defaultValueSpecification: Option[
      zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.ReadOnly
    ]
    def slotConstraint: zio.aws.lexmodelsv2.model.SlotConstraint
    def promptSpecification
        : Option[zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly]
    def sampleUtterances
        : Option[List[zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly]]
    def waitAndContinueSpecification: Option[
      zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.ReadOnly
    ]
    def getDefaultValueSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultValueSpecification",
      defaultValueSpecification
    )
    def getSlotConstraint
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SlotConstraint] =
      ZIO.succeed(slotConstraint)
    def getPromptSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("promptSpecification", promptSpecification)
    def getSampleUtterances: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly
    ]] = AwsError.unwrapOptionField("sampleUtterances", sampleUtterances)
    def getWaitAndContinueSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "waitAndContinueSpecification",
      waitAndContinueSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotValueElicitationSetting
  ) extends zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly {
    override val defaultValueSpecification: Option[
      zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.ReadOnly
    ] = scala
      .Option(impl.defaultValueSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.SlotDefaultValueSpecification.wrap(value)
      )
    override val slotConstraint: zio.aws.lexmodelsv2.model.SlotConstraint =
      zio.aws.lexmodelsv2.model.SlotConstraint.wrap(impl.slotConstraint())
    override val promptSpecification
        : Option[zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly] = scala
      .Option(impl.promptSpecification())
      .map(value => zio.aws.lexmodelsv2.model.PromptSpecification.wrap(value))
    override val sampleUtterances
        : Option[List[zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly]] =
      scala
        .Option(impl.sampleUtterances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.SampleUtterance.wrap(item)
          }.toList
        )
    override val waitAndContinueSpecification: Option[
      zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.ReadOnly
    ] = scala
      .Option(impl.waitAndContinueSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotValueElicitationSetting
  ): zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly =
    new Wrapper(impl)
}
