package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LexTranscriptFilter(
    dateRangeFilter: Option[zio.aws.lexmodelsv2.model.DateRangeFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.LexTranscriptFilter = {
    import LexTranscriptFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.LexTranscriptFilter
      .builder()
      .optionallyWith(dateRangeFilter.map(value => value.buildAwsValue()))(
        _.dateRangeFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.LexTranscriptFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.LexTranscriptFilter.wrap(buildAwsValue())
}
object LexTranscriptFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.LexTranscriptFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.LexTranscriptFilter =
      zio.aws.lexmodelsv2.model
        .LexTranscriptFilter(dateRangeFilter.map(value => value.asEditable))
    def dateRangeFilter
        : Option[zio.aws.lexmodelsv2.model.DateRangeFilter.ReadOnly]
    def getDateRangeFilter: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.DateRangeFilter.ReadOnly
    ] = AwsError.unwrapOptionField("dateRangeFilter", dateRangeFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.LexTranscriptFilter
  ) extends zio.aws.lexmodelsv2.model.LexTranscriptFilter.ReadOnly {
    override val dateRangeFilter
        : Option[zio.aws.lexmodelsv2.model.DateRangeFilter.ReadOnly] = scala
      .Option(impl.dateRangeFilter())
      .map(value => zio.aws.lexmodelsv2.model.DateRangeFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.LexTranscriptFilter
  ): zio.aws.lexmodelsv2.model.LexTranscriptFilter.ReadOnly = new Wrapper(impl)
}
