package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{PresignedS3Url, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateUploadUrlResponse(
    importId: Option[Id] = None,
    uploadUrl: Option[PresignedS3Url] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse = {
    import CreateUploadUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse
      .builder()
      .optionallyWith(
        importId.map(value => Id.unwrap(value): java.lang.String)
      )(_.importId)
      .optionallyWith(
        uploadUrl.map(value => PresignedS3Url.unwrap(value): java.lang.String)
      )(_.uploadUrl)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.wrap(buildAwsValue())
}
object CreateUploadUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateUploadUrlResponse =
      zio.aws.lexmodelsv2.model.CreateUploadUrlResponse(
        importId.map(value => value),
        uploadUrl.map(value => value)
      )
    def importId: Option[Id]
    def uploadUrl: Option[PresignedS3Url]
    def getImportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("importId", importId)
    def getUploadUrl: ZIO[Any, AwsError, PresignedS3Url] =
      AwsError.unwrapOptionField("uploadUrl", uploadUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse
  ) extends zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.ReadOnly {
    override val importId: Option[Id] = scala
      .Option(impl.importId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val uploadUrl: Option[PresignedS3Url] = scala
      .Option(impl.uploadUrl())
      .map(value => zio.aws.lexmodelsv2.model.primitives.PresignedS3Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse
  ): zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.ReadOnly = new Wrapper(
    impl
  )
}
