package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListBuiltInIntentsResponse(
    builtInIntentSummaries: Option[
      Iterable[zio.aws.lexmodelsv2.model.BuiltInIntentSummary]
    ] = None,
    nextToken: Option[NextToken] = None,
    localeId: Option[LocaleId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse = {
    import ListBuiltInIntentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse
      .builder()
      .optionallyWith(
        builtInIntentSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.builtInIntentSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.wrap(buildAwsValue())
}
object ListBuiltInIntentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse =
      zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse(
        builtInIntentSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        localeId.map(value => value)
      )
    def builtInIntentSummaries
        : Option[List[zio.aws.lexmodelsv2.model.BuiltInIntentSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def localeId: Option[LocaleId]
    def getBuiltInIntentSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BuiltInIntentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "builtInIntentSummaries",
      builtInIntentSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse
  ) extends zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.ReadOnly {
    override val builtInIntentSummaries: Option[
      List[zio.aws.lexmodelsv2.model.BuiltInIntentSummary.ReadOnly]
    ] = scala
      .Option(impl.builtInIntentSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.BuiltInIntentSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse
  ): zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.ReadOnly =
    new Wrapper(impl)
}
