package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{NumericalBotVersion, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeBotVersionRequest(
    botId: Id,
    botVersion: NumericalBotVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest = {
    import DescribeBotVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(NumericalBotVersion.unwrap(botVersion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeBotVersionRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeBotVersionRequest.wrap(buildAwsValue())
}
object DescribeBotVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeBotVersionRequest =
      zio.aws.lexmodelsv2.model.DescribeBotVersionRequest(botId, botVersion)
    def botId: Id
    def botVersion: NumericalBotVersion
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, NumericalBotVersion] =
      ZIO.succeed(botVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest
  ) extends zio.aws.lexmodelsv2.model.DescribeBotVersionRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: NumericalBotVersion =
      zio.aws.lexmodelsv2.model.primitives
        .NumericalBotVersion(impl.botVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest
  ): zio.aws.lexmodelsv2.model.DescribeBotVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
