package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  BoxedBoolean,
  FulfillmentUpdateResponseFrequency
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FulfillmentUpdateResponseSpecification(
    frequencyInSeconds: FulfillmentUpdateResponseFrequency,
    messageGroups: Iterable[zio.aws.lexmodelsv2.model.MessageGroup],
    allowInterrupt: Option[BoxedBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification = {
    import FulfillmentUpdateResponseSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification
      .builder()
      .frequencyInSeconds(
        FulfillmentUpdateResponseFrequency.unwrap(frequencyInSeconds): Integer
      )
      .messageGroups(messageGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(allowInterrupt.map(value => value: java.lang.Boolean))(
        _.allowInterrupt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.FulfillmentUpdateResponseSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.FulfillmentUpdateResponseSpecification
      .wrap(buildAwsValue())
}
object FulfillmentUpdateResponseSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.FulfillmentUpdateResponseSpecification =
      zio.aws.lexmodelsv2.model.FulfillmentUpdateResponseSpecification(
        frequencyInSeconds,
        messageGroups.map { item =>
          item.asEditable
        },
        allowInterrupt.map(value => value)
      )
    def frequencyInSeconds: FulfillmentUpdateResponseFrequency
    def messageGroups: List[zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly]
    def allowInterrupt: Option[BoxedBoolean]
    def getFrequencyInSeconds
        : ZIO[Any, Nothing, FulfillmentUpdateResponseFrequency] =
      ZIO.succeed(frequencyInSeconds)
    def getMessageGroups: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly
    ]] = ZIO.succeed(messageGroups)
    def getAllowInterrupt: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("allowInterrupt", allowInterrupt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification
  ) extends zio.aws.lexmodelsv2.model.FulfillmentUpdateResponseSpecification.ReadOnly {
    override val frequencyInSeconds: FulfillmentUpdateResponseFrequency =
      zio.aws.lexmodelsv2.model.primitives
        .FulfillmentUpdateResponseFrequency(impl.frequencyInSeconds())
    override val messageGroups
        : List[zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly] = impl
      .messageGroups()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.MessageGroup.wrap(item)
      }
      .toList
    override val allowInterrupt: Option[BoxedBoolean] =
      scala.Option(impl.allowInterrupt()).map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification
  ): zio.aws.lexmodelsv2.model.FulfillmentUpdateResponseSpecification.ReadOnly =
    new Wrapper(impl)
}
