package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  NextToken,
  LocaleId,
  DraftBotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRecommendedIntentsResponse(
    botId: Option[Id] = None,
    botVersion: Option[DraftBotVersion] = None,
    localeId: Option[LocaleId] = None,
    botRecommendationId: Option[Id] = None,
    summaryList: Option[
      Iterable[zio.aws.lexmodelsv2.model.RecommendedIntentSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse = {
    import ListRecommendedIntentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        botRecommendationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.botRecommendationId)
      .optionallyWith(
        summaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListRecommendedIntentsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListRecommendedIntentsResponse
      .wrap(buildAwsValue())
}
object ListRecommendedIntentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListRecommendedIntentsResponse =
      zio.aws.lexmodelsv2.model.ListRecommendedIntentsResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        botRecommendationId.map(value => value),
        summaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def botId: Option[Id]
    def botVersion: Option[DraftBotVersion]
    def localeId: Option[LocaleId]
    def botRecommendationId: Option[Id]
    def summaryList: Option[
      List[zio.aws.lexmodelsv2.model.RecommendedIntentSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getBotRecommendationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botRecommendationId", botRecommendationId)
    def getSummaryList: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.RecommendedIntentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaryList", summaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse
  ) extends zio.aws.lexmodelsv2.model.ListRecommendedIntentsResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[DraftBotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val botRecommendationId: Option[Id] = scala
      .Option(impl.botRecommendationId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val summaryList: Option[
      List[zio.aws.lexmodelsv2.model.RecommendedIntentSummary.ReadOnly]
    ] = scala
      .Option(impl.summaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.RecommendedIntentSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse
  ): zio.aws.lexmodelsv2.model.ListRecommendedIntentsResponse.ReadOnly =
    new Wrapper(impl)
}
