package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  IntentSignature,
  Timestamp,
  Description,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class IntentSummary(
    intentId: Option[Id] = None,
    intentName: Option[Name] = None,
    description: Option[Description] = None,
    parentIntentSignature: Option[IntentSignature] = None,
    inputContexts: Option[Iterable[zio.aws.lexmodelsv2.model.InputContext]] =
      None,
    outputContexts: Option[Iterable[zio.aws.lexmodelsv2.model.OutputContext]] =
      None,
    lastUpdatedDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary = {
    import IntentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary
      .builder()
      .optionallyWith(
        intentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.intentId)
      .optionallyWith(
        intentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        parentIntentSignature.map(value =>
          IntentSignature.unwrap(value): java.lang.String
        )
      )(_.parentIntentSignature)
      .optionallyWith(
        inputContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputContexts)
      .optionallyWith(
        outputContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputContexts)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.IntentSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentSummary.wrap(buildAwsValue())
}
object IntentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.IntentSummary =
      zio.aws.lexmodelsv2.model.IntentSummary(
        intentId.map(value => value),
        intentName.map(value => value),
        description.map(value => value),
        parentIntentSignature.map(value => value),
        inputContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastUpdatedDateTime.map(value => value)
      )
    def intentId: Option[Id]
    def intentName: Option[Name]
    def description: Option[Description]
    def parentIntentSignature: Option[IntentSignature]
    def inputContexts
        : Option[List[zio.aws.lexmodelsv2.model.InputContext.ReadOnly]]
    def outputContexts
        : Option[List[zio.aws.lexmodelsv2.model.OutputContext.ReadOnly]]
    def lastUpdatedDateTime: Option[Timestamp]
    def getIntentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("intentId", intentId)
    def getIntentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParentIntentSignature: ZIO[Any, AwsError, IntentSignature] =
      AwsError.unwrapOptionField("parentIntentSignature", parentIntentSignature)
    def getInputContexts: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.InputContext.ReadOnly
    ]] = AwsError.unwrapOptionField("inputContexts", inputContexts)
    def getOutputContexts: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.OutputContext.ReadOnly
    ]] = AwsError.unwrapOptionField("outputContexts", outputContexts)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary
  ) extends zio.aws.lexmodelsv2.model.IntentSummary.ReadOnly {
    override val intentId: Option[Id] = scala
      .Option(impl.intentId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val intentName: Option[Name] = scala
      .Option(impl.intentName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val parentIntentSignature: Option[IntentSignature] = scala
      .Option(impl.parentIntentSignature())
      .map(value => zio.aws.lexmodelsv2.model.primitives.IntentSignature(value))
    override val inputContexts
        : Option[List[zio.aws.lexmodelsv2.model.InputContext.ReadOnly]] = scala
      .Option(impl.inputContexts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.InputContext.wrap(item)
        }.toList
      )
    override val outputContexts
        : Option[List[zio.aws.lexmodelsv2.model.OutputContext.ReadOnly]] = scala
      .Option(impl.outputContexts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.OutputContext.wrap(item)
        }.toList
      )
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary
  ): zio.aws.lexmodelsv2.model.IntentSummary.ReadOnly = new Wrapper(impl)
}
