package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Timestamp, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class UpdateExportResponse(
    exportId: Option[Id] = None,
    resourceSpecification: Option[
      zio.aws.lexmodelsv2.model.ExportResourceSpecification
    ] = None,
    fileFormat: Option[zio.aws.lexmodelsv2.model.ImportExportFileFormat] = None,
    exportStatus: Option[zio.aws.lexmodelsv2.model.ExportStatus] = None,
    creationDateTime: Option[Timestamp] = None,
    lastUpdatedDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse = {
    import UpdateExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse
      .builder()
      .optionallyWith(
        exportId.map(value => Id.unwrap(value): java.lang.String)
      )(_.exportId)
      .optionallyWith(
        resourceSpecification.map(value => value.buildAwsValue())
      )(_.resourceSpecification)
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(exportStatus.map(value => value.unwrap))(_.exportStatus)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateExportResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateExportResponse.wrap(buildAwsValue())
}
object UpdateExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateExportResponse =
      zio.aws.lexmodelsv2.model.UpdateExportResponse(
        exportId.map(value => value),
        resourceSpecification.map(value => value.asEditable),
        fileFormat.map(value => value),
        exportStatus.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def exportId: Option[Id]
    def resourceSpecification
        : Option[zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly]
    def fileFormat: Option[zio.aws.lexmodelsv2.model.ImportExportFileFormat]
    def exportStatus: Option[zio.aws.lexmodelsv2.model.ExportStatus]
    def creationDateTime: Option[Timestamp]
    def lastUpdatedDateTime: Option[Timestamp]
    def getExportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("exportId", exportId)
    def getResourceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("resourceSpecification", resourceSpecification)
    def getFileFormat
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ImportExportFileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getExportStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ExportStatus] =
      AwsError.unwrapOptionField("exportStatus", exportStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse
  ) extends zio.aws.lexmodelsv2.model.UpdateExportResponse.ReadOnly {
    override val exportId: Option[Id] = scala
      .Option(impl.exportId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val resourceSpecification: Option[
      zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly
    ] = scala
      .Option(impl.resourceSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.ExportResourceSpecification.wrap(value)
      )
    override val fileFormat
        : Option[zio.aws.lexmodelsv2.model.ImportExportFileFormat] = scala
      .Option(impl.fileFormat())
      .map(value =>
        zio.aws.lexmodelsv2.model.ImportExportFileFormat.wrap(value)
      )
    override val exportStatus: Option[zio.aws.lexmodelsv2.model.ExportStatus] =
      scala
        .Option(impl.exportStatus())
        .map(value => zio.aws.lexmodelsv2.model.ExportStatus.wrap(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse
  ): zio.aws.lexmodelsv2.model.UpdateExportResponse.ReadOnly = new Wrapper(impl)
}
