package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  Timestamp,
  Description,
  BotVersion,
  Name,
  BuiltInOrCustomSlotTypeId,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeSlotResponse(
    slotId: Option[Id] = None,
    slotName: Option[Name] = None,
    description: Option[Description] = None,
    slotTypeId: Option[BuiltInOrCustomSlotTypeId] = None,
    valueElicitationSetting: Option[
      zio.aws.lexmodelsv2.model.SlotValueElicitationSetting
    ] = None,
    obfuscationSetting: Option[zio.aws.lexmodelsv2.model.ObfuscationSetting] =
      None,
    botId: Option[Id] = None,
    botVersion: Option[BotVersion] = None,
    localeId: Option[LocaleId] = None,
    intentId: Option[Id] = None,
    creationDateTime: Option[Timestamp] = None,
    lastUpdatedDateTime: Option[Timestamp] = None,
    multipleValuesSetting: Option[
      zio.aws.lexmodelsv2.model.MultipleValuesSetting
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotResponse = {
    import DescribeSlotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotResponse
      .builder()
      .optionallyWith(slotId.map(value => Id.unwrap(value): java.lang.String))(
        _.slotId
      )
      .optionallyWith(
        slotName.map(value => Name.unwrap(value): java.lang.String)
      )(_.slotName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        slotTypeId.map(value =>
          BuiltInOrCustomSlotTypeId.unwrap(value): java.lang.String
        )
      )(_.slotTypeId)
      .optionallyWith(
        valueElicitationSetting.map(value => value.buildAwsValue())
      )(_.valueElicitationSetting)
      .optionallyWith(obfuscationSetting.map(value => value.buildAwsValue()))(
        _.obfuscationSetting
      )
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        intentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.intentId)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        multipleValuesSetting.map(value => value.buildAwsValue())
      )(_.multipleValuesSetting)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeSlotResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeSlotResponse.wrap(buildAwsValue())
}
object DescribeSlotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeSlotResponse =
      zio.aws.lexmodelsv2.model.DescribeSlotResponse(
        slotId.map(value => value),
        slotName.map(value => value),
        description.map(value => value),
        slotTypeId.map(value => value),
        valueElicitationSetting.map(value => value.asEditable),
        obfuscationSetting.map(value => value.asEditable),
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        intentId.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        multipleValuesSetting.map(value => value.asEditable)
      )
    def slotId: Option[Id]
    def slotName: Option[Name]
    def description: Option[Description]
    def slotTypeId: Option[BuiltInOrCustomSlotTypeId]
    def valueElicitationSetting
        : Option[zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly]
    def obfuscationSetting
        : Option[zio.aws.lexmodelsv2.model.ObfuscationSetting.ReadOnly]
    def botId: Option[Id]
    def botVersion: Option[BotVersion]
    def localeId: Option[LocaleId]
    def intentId: Option[Id]
    def creationDateTime: Option[Timestamp]
    def lastUpdatedDateTime: Option[Timestamp]
    def multipleValuesSetting
        : Option[zio.aws.lexmodelsv2.model.MultipleValuesSetting.ReadOnly]
    def getSlotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("slotId", slotId)
    def getSlotName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("slotName", slotName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSlotTypeId: ZIO[Any, AwsError, BuiltInOrCustomSlotTypeId] =
      AwsError.unwrapOptionField("slotTypeId", slotTypeId)
    def getValueElicitationSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly
    ] = AwsError.unwrapOptionField(
      "valueElicitationSetting",
      valueElicitationSetting
    )
    def getObfuscationSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ObfuscationSetting.ReadOnly
    ] = AwsError.unwrapOptionField("obfuscationSetting", obfuscationSetting)
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getIntentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("intentId", intentId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getMultipleValuesSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.MultipleValuesSetting.ReadOnly
    ] =
      AwsError.unwrapOptionField("multipleValuesSetting", multipleValuesSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotResponse
  ) extends zio.aws.lexmodelsv2.model.DescribeSlotResponse.ReadOnly {
    override val slotId: Option[Id] = scala
      .Option(impl.slotId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val slotName: Option[Name] = scala
      .Option(impl.slotName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val slotTypeId: Option[BuiltInOrCustomSlotTypeId] = scala
      .Option(impl.slotTypeId())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.BuiltInOrCustomSlotTypeId(value)
      )
    override val valueElicitationSetting: Option[
      zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly
    ] = scala
      .Option(impl.valueElicitationSetting())
      .map(value =>
        zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.wrap(value)
      )
    override val obfuscationSetting
        : Option[zio.aws.lexmodelsv2.model.ObfuscationSetting.ReadOnly] = scala
      .Option(impl.obfuscationSetting())
      .map(value => zio.aws.lexmodelsv2.model.ObfuscationSetting.wrap(value))
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val intentId: Option[Id] = scala
      .Option(impl.intentId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val multipleValuesSetting
        : Option[zio.aws.lexmodelsv2.model.MultipleValuesSetting.ReadOnly] =
      scala
        .Option(impl.multipleValuesSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.MultipleValuesSetting.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotResponse
  ): zio.aws.lexmodelsv2.model.DescribeSlotResponse.ReadOnly = new Wrapper(impl)
}
