package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  NextToken,
  DraftBotVersion,
  MaxResults,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRecommendedIntentsRequest(
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId,
    botRecommendationId: Id,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest = {
    import ListRecommendedIntentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .botRecommendationId(Id.unwrap(botRecommendationId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListRecommendedIntentsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListRecommendedIntentsRequest
      .wrap(buildAwsValue())
}
object ListRecommendedIntentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListRecommendedIntentsRequest =
      zio.aws.lexmodelsv2.model.ListRecommendedIntentsRequest(
        botId,
        botVersion,
        localeId,
        botRecommendationId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def botRecommendationId: Id
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getBotRecommendationId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(botRecommendationId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest
  ) extends zio.aws.lexmodelsv2.model.ListRecommendedIntentsRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val botRecommendationId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botRecommendationId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest
  ): zio.aws.lexmodelsv2.model.ListRecommendedIntentsRequest.ReadOnly =
    new Wrapper(impl)
}
