package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  NextToken,
  BotAliasId,
  MaxResults,
  BotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAggregatedUtterancesRequest(
    botId: Id,
    botAliasId: Option[BotAliasId] = None,
    botVersion: Option[BotVersion] = None,
    localeId: LocaleId,
    aggregationDuration: zio.aws.lexmodelsv2.model.UtteranceAggregationDuration,
    sortBy: Option[zio.aws.lexmodelsv2.model.AggregatedUtterancesSortBy] = None,
    filters: Option[
      Iterable[zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter]
    ] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest = {
    import ListAggregatedUtterancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .optionallyWith(
        botAliasId.map(value => BotAliasId.unwrap(value): java.lang.String)
      )(_.botAliasId)
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .aggregationDuration(aggregationDuration.buildAwsValue())
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListAggregatedUtterancesRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListAggregatedUtterancesRequest
      .wrap(buildAwsValue())
}
object ListAggregatedUtterancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListAggregatedUtterancesRequest =
      zio.aws.lexmodelsv2.model.ListAggregatedUtterancesRequest(
        botId,
        botAliasId.map(value => value),
        botVersion.map(value => value),
        localeId,
        aggregationDuration.asEditable,
        sortBy.map(value => value.asEditable),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def botId: Id
    def botAliasId: Option[BotAliasId]
    def botVersion: Option[BotVersion]
    def localeId: LocaleId
    def aggregationDuration
        : zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.ReadOnly
    def sortBy
        : Option[zio.aws.lexmodelsv2.model.AggregatedUtterancesSortBy.ReadOnly]
    def filters: Option[
      List[zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter.ReadOnly]
    ]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotAliasId: ZIO[Any, AwsError, BotAliasId] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getAggregationDuration: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.ReadOnly
    ] = ZIO.succeed(aggregationDuration)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AggregatedUtterancesSortBy.ReadOnly
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest
  ) extends zio.aws.lexmodelsv2.model.ListAggregatedUtterancesRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botAliasId: Option[BotAliasId] = scala
      .Option(impl.botAliasId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotAliasId(value))
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val aggregationDuration
        : zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.ReadOnly =
      zio.aws.lexmodelsv2.model.UtteranceAggregationDuration
        .wrap(impl.aggregationDuration())
    override val sortBy: Option[
      zio.aws.lexmodelsv2.model.AggregatedUtterancesSortBy.ReadOnly
    ] = scala
      .Option(impl.sortBy())
      .map(value =>
        zio.aws.lexmodelsv2.model.AggregatedUtterancesSortBy.wrap(value)
      )
    override val filters: Option[
      List[zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter.wrap(item)
        }.toList
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest
  ): zio.aws.lexmodelsv2.model.ListAggregatedUtterancesRequest.ReadOnly =
    new Wrapper(impl)
}
