package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  RecommendedAction,
  LocaleName,
  Timestamp,
  FailureReason,
  ConfidenceThreshold,
  DraftBotVersion,
  Description,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class UpdateBotLocaleResponse(
    botId: Option[Id] = None,
    botVersion: Option[DraftBotVersion] = None,
    localeId: Option[LocaleId] = None,
    localeName: Option[LocaleName] = None,
    description: Option[Description] = None,
    nluIntentConfidenceThreshold: Option[ConfidenceThreshold] = None,
    voiceSettings: Option[zio.aws.lexmodelsv2.model.VoiceSettings] = None,
    botLocaleStatus: Option[zio.aws.lexmodelsv2.model.BotLocaleStatus] = None,
    failureReasons: Option[Iterable[FailureReason]] = None,
    creationDateTime: Option[Timestamp] = None,
    lastUpdatedDateTime: Option[Timestamp] = None,
    recommendedActions: Option[Iterable[RecommendedAction]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleResponse = {
    import UpdateBotLocaleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        localeName.map(value => LocaleName.unwrap(value): java.lang.String)
      )(_.localeName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        nluIntentConfidenceThreshold.map(value =>
          ConfidenceThreshold.unwrap(value): java.lang.Double
        )
      )(_.nluIntentConfidenceThreshold)
      .optionallyWith(voiceSettings.map(value => value.buildAwsValue()))(
        _.voiceSettings
      )
      .optionallyWith(botLocaleStatus.map(value => value.unwrap))(
        _.botLocaleStatus
      )
      .optionallyWith(
        failureReasons.map(value =>
          value.map { item =>
            FailureReason.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.failureReasons)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        recommendedActions.map(value =>
          value.map { item =>
            RecommendedAction.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.recommendedActions)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateBotLocaleResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateBotLocaleResponse.wrap(buildAwsValue())
}
object UpdateBotLocaleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateBotLocaleResponse =
      zio.aws.lexmodelsv2.model.UpdateBotLocaleResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        localeName.map(value => value),
        description.map(value => value),
        nluIntentConfidenceThreshold.map(value => value),
        voiceSettings.map(value => value.asEditable),
        botLocaleStatus.map(value => value),
        failureReasons.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        recommendedActions.map(value => value)
      )
    def botId: Option[Id]
    def botVersion: Option[DraftBotVersion]
    def localeId: Option[LocaleId]
    def localeName: Option[LocaleName]
    def description: Option[Description]
    def nluIntentConfidenceThreshold: Option[ConfidenceThreshold]
    def voiceSettings: Option[zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly]
    def botLocaleStatus: Option[zio.aws.lexmodelsv2.model.BotLocaleStatus]
    def failureReasons: Option[List[FailureReason]]
    def creationDateTime: Option[Timestamp]
    def lastUpdatedDateTime: Option[Timestamp]
    def recommendedActions: Option[List[RecommendedAction]]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getLocaleName: ZIO[Any, AwsError, LocaleName] =
      AwsError.unwrapOptionField("localeName", localeName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNluIntentConfidenceThreshold
        : ZIO[Any, AwsError, ConfidenceThreshold] = AwsError.unwrapOptionField(
      "nluIntentConfidenceThreshold",
      nluIntentConfidenceThreshold
    )
    def getVoiceSettings
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly] =
      AwsError.unwrapOptionField("voiceSettings", voiceSettings)
    def getBotLocaleStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotLocaleStatus] =
      AwsError.unwrapOptionField("botLocaleStatus", botLocaleStatus)
    def getFailureReasons: ZIO[Any, AwsError, List[FailureReason]] =
      AwsError.unwrapOptionField("failureReasons", failureReasons)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getRecommendedActions: ZIO[Any, AwsError, List[RecommendedAction]] =
      AwsError.unwrapOptionField("recommendedActions", recommendedActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleResponse
  ) extends zio.aws.lexmodelsv2.model.UpdateBotLocaleResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[DraftBotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val localeName: Option[LocaleName] = scala
      .Option(impl.localeName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val nluIntentConfidenceThreshold: Option[ConfidenceThreshold] =
      scala
        .Option(impl.nluIntentConfidenceThreshold())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.ConfidenceThreshold(value)
        )
    override val voiceSettings
        : Option[zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly] = scala
      .Option(impl.voiceSettings())
      .map(value => zio.aws.lexmodelsv2.model.VoiceSettings.wrap(value))
    override val botLocaleStatus
        : Option[zio.aws.lexmodelsv2.model.BotLocaleStatus] = scala
      .Option(impl.botLocaleStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotLocaleStatus.wrap(value))
    override val failureReasons: Option[List[FailureReason]] = scala
      .Option(impl.failureReasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.primitives.FailureReason(item)
        }.toList
      )
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val recommendedActions: Option[List[RecommendedAction]] = scala
      .Option(impl.recommendedActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.primitives.RecommendedAction(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleResponse
  ): zio.aws.lexmodelsv2.model.UpdateBotLocaleResponse.ReadOnly = new Wrapper(
    impl
  )
}
