package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{NextToken, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListBotVersionsResponse(
    botId: Option[Id] = None,
    botVersionSummaries: Option[
      Iterable[zio.aws.lexmodelsv2.model.BotVersionSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse = {
    import ListBotVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersionSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.botVersionSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListBotVersionsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBotVersionsResponse.wrap(buildAwsValue())
}
object ListBotVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBotVersionsResponse =
      zio.aws.lexmodelsv2.model.ListBotVersionsResponse(
        botId.map(value => value),
        botVersionSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def botId: Option[Id]
    def botVersionSummaries
        : Option[List[zio.aws.lexmodelsv2.model.BotVersionSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersionSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotVersionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("botVersionSummaries", botVersionSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse
  ) extends zio.aws.lexmodelsv2.model.ListBotVersionsResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersionSummaries
        : Option[List[zio.aws.lexmodelsv2.model.BotVersionSummary.ReadOnly]] =
      scala
        .Option(impl.botVersionSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.BotVersionSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse
  ): zio.aws.lexmodelsv2.model.ListBotVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
