package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{PrincipalArn, ServicePrincipal}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Principal(
    service: Option[ServicePrincipal] = None,
    arn: Option[PrincipalArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.Principal = {
    import Principal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.Principal
      .builder()
      .optionallyWith(
        service.map(value => ServicePrincipal.unwrap(value): java.lang.String)
      )(_.service)
      .optionallyWith(
        arn.map(value => PrincipalArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.Principal.ReadOnly =
    zio.aws.lexmodelsv2.model.Principal.wrap(buildAwsValue())
}
object Principal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.Principal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.Principal =
      zio.aws.lexmodelsv2.model
        .Principal(service.map(value => value), arn.map(value => value))
    def service: Option[ServicePrincipal]
    def arn: Option[PrincipalArn]
    def getService: ZIO[Any, AwsError, ServicePrincipal] =
      AwsError.unwrapOptionField("service", service)
    def getArn: ZIO[Any, AwsError, PrincipalArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.Principal
  ) extends zio.aws.lexmodelsv2.model.Principal.ReadOnly {
    override val service: Option[ServicePrincipal] = scala
      .Option(impl.service())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.ServicePrincipal(value)
      )
    override val arn: Option[PrincipalArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lexmodelsv2.model.primitives.PrincipalArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.Principal
  ): zio.aws.lexmodelsv2.model.Principal.ReadOnly = new Wrapper(impl)
}
