package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  RoleArn,
  Timestamp,
  TagValue,
  SessionTTL,
  Description,
  Name,
  Id,
  TagKey
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateBotResponse(
    botId: Option[Id] = None,
    botName: Option[Name] = None,
    description: Option[Description] = None,
    roleArn: Option[RoleArn] = None,
    dataPrivacy: Option[zio.aws.lexmodelsv2.model.DataPrivacy] = None,
    idleSessionTTLInSeconds: Option[SessionTTL] = None,
    botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus] = None,
    creationDateTime: Option[Timestamp] = None,
    botTags: Option[Map[TagKey, TagValue]] = None,
    testBotAliasTags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateBotResponse = {
    import CreateBotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(dataPrivacy.map(value => value.buildAwsValue()))(
        _.dataPrivacy
      )
      .optionallyWith(
        idleSessionTTLInSeconds.map(value => SessionTTL.unwrap(value): Integer)
      )(_.idleSessionTTLInSeconds)
      .optionallyWith(botStatus.map(value => value.unwrap))(_.botStatus)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        botTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.botTags)
      .optionallyWith(
        testBotAliasTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.testBotAliasTags)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateBotResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateBotResponse.wrap(buildAwsValue())
}
object CreateBotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateBotResponse =
      zio.aws.lexmodelsv2.model.CreateBotResponse(
        botId.map(value => value),
        botName.map(value => value),
        description.map(value => value),
        roleArn.map(value => value),
        dataPrivacy.map(value => value.asEditable),
        idleSessionTTLInSeconds.map(value => value),
        botStatus.map(value => value),
        creationDateTime.map(value => value),
        botTags.map(value => value),
        testBotAliasTags.map(value => value)
      )
    def botId: Option[Id]
    def botName: Option[Name]
    def description: Option[Description]
    def roleArn: Option[RoleArn]
    def dataPrivacy: Option[zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly]
    def idleSessionTTLInSeconds: Option[SessionTTL]
    def botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus]
    def creationDateTime: Option[Timestamp]
    def botTags: Option[Map[TagKey, TagValue]]
    def testBotAliasTags: Option[Map[TagKey, TagValue]]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botName", botName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDataPrivacy
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly] =
      AwsError.unwrapOptionField("dataPrivacy", dataPrivacy)
    def getIdleSessionTTLInSeconds: ZIO[Any, AwsError, SessionTTL] = AwsError
      .unwrapOptionField("idleSessionTTLInSeconds", idleSessionTTLInSeconds)
    def getBotStatus: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotStatus] =
      AwsError.unwrapOptionField("botStatus", botStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getBotTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("botTags", botTags)
    def getTestBotAliasTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("testBotAliasTags", testBotAliasTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotResponse
  ) extends zio.aws.lexmodelsv2.model.CreateBotResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botName: Option[Name] = scala
      .Option(impl.botName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.lexmodelsv2.model.primitives.RoleArn(value))
    override val dataPrivacy
        : Option[zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly] = scala
      .Option(impl.dataPrivacy())
      .map(value => zio.aws.lexmodelsv2.model.DataPrivacy.wrap(value))
    override val idleSessionTTLInSeconds: Option[SessionTTL] = scala
      .Option(impl.idleSessionTTLInSeconds())
      .map(value => zio.aws.lexmodelsv2.model.primitives.SessionTTL(value))
    override val botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus] = scala
      .Option(impl.botStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotStatus.wrap(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val botTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.botTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.TagKey(
              key
            ) -> zio.aws.lexmodelsv2.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val testBotAliasTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.testBotAliasTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.TagKey(
              key
            ) -> zio.aws.lexmodelsv2.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotResponse
  ): zio.aws.lexmodelsv2.model.CreateBotResponse.ReadOnly = new Wrapper(impl)
}
