package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  RoleArn,
  TagValue,
  SessionTTL,
  Description,
  Name,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateBotRequest(
    botName: Name,
    description: Option[Description] = None,
    roleArn: RoleArn,
    dataPrivacy: zio.aws.lexmodelsv2.model.DataPrivacy,
    idleSessionTTLInSeconds: SessionTTL,
    botTags: Option[Map[TagKey, TagValue]] = None,
    testBotAliasTags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest = {
    import CreateBotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest
      .builder()
      .botName(Name.unwrap(botName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .dataPrivacy(dataPrivacy.buildAwsValue())
      .idleSessionTTLInSeconds(
        SessionTTL.unwrap(idleSessionTTLInSeconds): Integer
      )
      .optionallyWith(
        botTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.botTags)
      .optionallyWith(
        testBotAliasTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.testBotAliasTags)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateBotRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateBotRequest.wrap(buildAwsValue())
}
object CreateBotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateBotRequest =
      zio.aws.lexmodelsv2.model.CreateBotRequest(
        botName,
        description.map(value => value),
        roleArn,
        dataPrivacy.asEditable,
        idleSessionTTLInSeconds,
        botTags.map(value => value),
        testBotAliasTags.map(value => value)
      )
    def botName: Name
    def description: Option[Description]
    def roleArn: RoleArn
    def dataPrivacy: zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly
    def idleSessionTTLInSeconds: SessionTTL
    def botTags: Option[Map[TagKey, TagValue]]
    def testBotAliasTags: Option[Map[TagKey, TagValue]]
    def getBotName: ZIO[Any, Nothing, Name] = ZIO.succeed(botName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getDataPrivacy
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly] =
      ZIO.succeed(dataPrivacy)
    def getIdleSessionTTLInSeconds: ZIO[Any, Nothing, SessionTTL] =
      ZIO.succeed(idleSessionTTLInSeconds)
    def getBotTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("botTags", botTags)
    def getTestBotAliasTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("testBotAliasTags", testBotAliasTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest
  ) extends zio.aws.lexmodelsv2.model.CreateBotRequest.ReadOnly {
    override val botName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.botName())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val roleArn: RoleArn =
      zio.aws.lexmodelsv2.model.primitives.RoleArn(impl.roleArn())
    override val dataPrivacy: zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly =
      zio.aws.lexmodelsv2.model.DataPrivacy.wrap(impl.dataPrivacy())
    override val idleSessionTTLInSeconds: SessionTTL =
      zio.aws.lexmodelsv2.model.primitives
        .SessionTTL(impl.idleSessionTTLInSeconds())
    override val botTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.botTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.TagKey(
              key
            ) -> zio.aws.lexmodelsv2.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val testBotAliasTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.testBotAliasTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.TagKey(
              key
            ) -> zio.aws.lexmodelsv2.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest
  ): zio.aws.lexmodelsv2.model.CreateBotRequest.ReadOnly = new Wrapper(impl)
}
