package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AdvancedRecognitionSetting(
    audioRecognitionStrategy: Option[
      zio.aws.lexmodelsv2.model.AudioRecognitionStrategy
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AdvancedRecognitionSetting = {
    import AdvancedRecognitionSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AdvancedRecognitionSetting
      .builder()
      .optionallyWith(audioRecognitionStrategy.map(value => value.unwrap))(
        _.audioRecognitionStrategy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AdvancedRecognitionSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.AdvancedRecognitionSetting.wrap(buildAwsValue())
}
object AdvancedRecognitionSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AdvancedRecognitionSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AdvancedRecognitionSetting =
      zio.aws.lexmodelsv2.model.AdvancedRecognitionSetting(
        audioRecognitionStrategy.map(value => value)
      )
    def audioRecognitionStrategy
        : Option[zio.aws.lexmodelsv2.model.AudioRecognitionStrategy]
    def getAudioRecognitionStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AudioRecognitionStrategy
    ] = AwsError.unwrapOptionField(
      "audioRecognitionStrategy",
      audioRecognitionStrategy
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AdvancedRecognitionSetting
  ) extends zio.aws.lexmodelsv2.model.AdvancedRecognitionSetting.ReadOnly {
    override val audioRecognitionStrategy
        : Option[zio.aws.lexmodelsv2.model.AudioRecognitionStrategy] = scala
      .Option(impl.audioRecognitionStrategy())
      .map(value =>
        zio.aws.lexmodelsv2.model.AudioRecognitionStrategy.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AdvancedRecognitionSetting
  ): zio.aws.lexmodelsv2.model.AdvancedRecognitionSetting.ReadOnly =
    new Wrapper(impl)
}
