package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FulfillmentCodeHookSettings(
    enabled: Boolean,
    postFulfillmentStatusSpecification: Option[
      zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification
    ] = None,
    fulfillmentUpdatesSpecification: Option[
      zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentCodeHookSettings = {
    import FulfillmentCodeHookSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentCodeHookSettings
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        postFulfillmentStatusSpecification.map(value => value.buildAwsValue())
      )(_.postFulfillmentStatusSpecification)
      .optionallyWith(
        fulfillmentUpdatesSpecification.map(value => value.buildAwsValue())
      )(_.fulfillmentUpdatesSpecification)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.ReadOnly =
    zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.wrap(buildAwsValue())
}
object FulfillmentCodeHookSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentCodeHookSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings =
      zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings(
        enabled,
        postFulfillmentStatusSpecification.map(value => value.asEditable),
        fulfillmentUpdatesSpecification.map(value => value.asEditable)
      )
    def enabled: Boolean
    def postFulfillmentStatusSpecification: Option[
      zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.ReadOnly
    ]
    def fulfillmentUpdatesSpecification: Option[
      zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification.ReadOnly
    ]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getPostFulfillmentStatusSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "postFulfillmentStatusSpecification",
      postFulfillmentStatusSpecification
    )
    def getFulfillmentUpdatesSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fulfillmentUpdatesSpecification",
      fulfillmentUpdatesSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentCodeHookSettings
  ) extends zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val postFulfillmentStatusSpecification: Option[
      zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.ReadOnly
    ] = scala
      .Option(impl.postFulfillmentStatusSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.wrap(value)
      )
    override val fulfillmentUpdatesSpecification: Option[
      zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification.ReadOnly
    ] = scala
      .Option(impl.fulfillmentUpdatesSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentCodeHookSettings
  ): zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.ReadOnly =
    new Wrapper(impl)
}
