package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BotRecommendationResultStatistics(
    intents: Option[zio.aws.lexmodelsv2.model.IntentStatistics] = None,
    slotTypes: Option[zio.aws.lexmodelsv2.model.SlotTypeStatistics] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationResultStatistics = {
    import BotRecommendationResultStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationResultStatistics
      .builder()
      .optionallyWith(intents.map(value => value.buildAwsValue()))(_.intents)
      .optionallyWith(slotTypes.map(value => value.buildAwsValue()))(
        _.slotTypes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.BotRecommendationResultStatistics.ReadOnly =
    zio.aws.lexmodelsv2.model.BotRecommendationResultStatistics
      .wrap(buildAwsValue())
}
object BotRecommendationResultStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationResultStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.BotRecommendationResultStatistics =
      zio.aws.lexmodelsv2.model.BotRecommendationResultStatistics(
        intents.map(value => value.asEditable),
        slotTypes.map(value => value.asEditable)
      )
    def intents: Option[zio.aws.lexmodelsv2.model.IntentStatistics.ReadOnly]
    def slotTypes: Option[zio.aws.lexmodelsv2.model.SlotTypeStatistics.ReadOnly]
    def getIntents: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.IntentStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("intents", intents)
    def getSlotTypes: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SlotTypeStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("slotTypes", slotTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationResultStatistics
  ) extends zio.aws.lexmodelsv2.model.BotRecommendationResultStatistics.ReadOnly {
    override val intents
        : Option[zio.aws.lexmodelsv2.model.IntentStatistics.ReadOnly] = scala
      .Option(impl.intents())
      .map(value => zio.aws.lexmodelsv2.model.IntentStatistics.wrap(value))
    override val slotTypes
        : Option[zio.aws.lexmodelsv2.model.SlotTypeStatistics.ReadOnly] = scala
      .Option(impl.slotTypes())
      .map(value => zio.aws.lexmodelsv2.model.SlotTypeStatistics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationResultStatistics
  ): zio.aws.lexmodelsv2.model.BotRecommendationResultStatistics.ReadOnly =
    new Wrapper(impl)
}
