package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  SlotTypeSignature,
  Description,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class SlotTypeSummary(
    slotTypeId: Option[Id] = None,
    slotTypeName: Option[Name] = None,
    description: Option[Description] = None,
    parentSlotTypeSignature: Option[SlotTypeSignature] = None,
    lastUpdatedDateTime: Option[Timestamp] = None,
    slotTypeCategory: Option[zio.aws.lexmodelsv2.model.SlotTypeCategory] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeSummary = {
    import SlotTypeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeSummary
      .builder()
      .optionallyWith(
        slotTypeId.map(value => Id.unwrap(value): java.lang.String)
      )(_.slotTypeId)
      .optionallyWith(
        slotTypeName.map(value => Name.unwrap(value): java.lang.String)
      )(_.slotTypeName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        parentSlotTypeSignature.map(value =>
          SlotTypeSignature.unwrap(value): java.lang.String
        )
      )(_.parentSlotTypeSignature)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(slotTypeCategory.map(value => value.unwrap))(
        _.slotTypeCategory
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotTypeSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotTypeSummary.wrap(buildAwsValue())
}
object SlotTypeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotTypeSummary =
      zio.aws.lexmodelsv2.model.SlotTypeSummary(
        slotTypeId.map(value => value),
        slotTypeName.map(value => value),
        description.map(value => value),
        parentSlotTypeSignature.map(value => value),
        lastUpdatedDateTime.map(value => value),
        slotTypeCategory.map(value => value)
      )
    def slotTypeId: Option[Id]
    def slotTypeName: Option[Name]
    def description: Option[Description]
    def parentSlotTypeSignature: Option[SlotTypeSignature]
    def lastUpdatedDateTime: Option[Timestamp]
    def slotTypeCategory: Option[zio.aws.lexmodelsv2.model.SlotTypeCategory]
    def getSlotTypeId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("slotTypeId", slotTypeId)
    def getSlotTypeName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("slotTypeName", slotTypeName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParentSlotTypeSignature: ZIO[Any, AwsError, SlotTypeSignature] =
      AwsError.unwrapOptionField(
        "parentSlotTypeSignature",
        parentSlotTypeSignature
      )
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getSlotTypeCategory
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.SlotTypeCategory] =
      AwsError.unwrapOptionField("slotTypeCategory", slotTypeCategory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeSummary
  ) extends zio.aws.lexmodelsv2.model.SlotTypeSummary.ReadOnly {
    override val slotTypeId: Option[Id] = scala
      .Option(impl.slotTypeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val slotTypeName: Option[Name] = scala
      .Option(impl.slotTypeName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val parentSlotTypeSignature: Option[SlotTypeSignature] = scala
      .Option(impl.parentSlotTypeSignature())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.SlotTypeSignature(value)
      )
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val slotTypeCategory
        : Option[zio.aws.lexmodelsv2.model.SlotTypeCategory] = scala
      .Option(impl.slotTypeCategory())
      .map(value => zio.aws.lexmodelsv2.model.SlotTypeCategory.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeSummary
  ): zio.aws.lexmodelsv2.model.SlotTypeSummary.ReadOnly = new Wrapper(impl)
}
