package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.Count
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IntentStatistics(discoveredIntentCount: Option[Count] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentStatistics = {
    import IntentStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentStatistics
      .builder()
      .optionallyWith(
        discoveredIntentCount.map(value => Count.unwrap(value): Integer)
      )(_.discoveredIntentCount)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.IntentStatistics.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentStatistics.wrap(buildAwsValue())
}
object IntentStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.IntentStatistics =
      zio.aws.lexmodelsv2.model
        .IntentStatistics(discoveredIntentCount.map(value => value))
    def discoveredIntentCount: Option[Count]
    def getDiscoveredIntentCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("discoveredIntentCount", discoveredIntentCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentStatistics
  ) extends zio.aws.lexmodelsv2.model.IntentStatistics.ReadOnly {
    override val discoveredIntentCount: Option[Count] = scala
      .Option(impl.discoveredIntentCount())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Count(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentStatistics
  ): zio.aws.lexmodelsv2.model.IntentStatistics.ReadOnly = new Wrapper(impl)
}
