package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Description, IntentSignature}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BuiltInIntentSummary(
    intentSignature: Option[IntentSignature] = None,
    description: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BuiltInIntentSummary = {
    import BuiltInIntentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BuiltInIntentSummary
      .builder()
      .optionallyWith(
        intentSignature.map(value =>
          IntentSignature.unwrap(value): java.lang.String
        )
      )(_.intentSignature)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BuiltInIntentSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.BuiltInIntentSummary.wrap(buildAwsValue())
}
object BuiltInIntentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BuiltInIntentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BuiltInIntentSummary =
      zio.aws.lexmodelsv2.model.BuiltInIntentSummary(
        intentSignature.map(value => value),
        description.map(value => value)
      )
    def intentSignature: Option[IntentSignature]
    def description: Option[Description]
    def getIntentSignature: ZIO[Any, AwsError, IntentSignature] =
      AwsError.unwrapOptionField("intentSignature", intentSignature)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BuiltInIntentSummary
  ) extends zio.aws.lexmodelsv2.model.BuiltInIntentSummary.ReadOnly {
    override val intentSignature: Option[IntentSignature] = scala
      .Option(impl.intentSignature())
      .map(value => zio.aws.lexmodelsv2.model.primitives.IntentSignature(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BuiltInIntentSummary
  ): zio.aws.lexmodelsv2.model.BuiltInIntentSummary.ReadOnly = new Wrapper(impl)
}
