package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  IntentSignature,
  DraftBotVersion,
  Description,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateIntentRequest(
    intentId: Id,
    intentName: Name,
    description: Option[Description] = None,
    parentIntentSignature: Option[IntentSignature] = None,
    sampleUtterances: Option[
      Iterable[zio.aws.lexmodelsv2.model.SampleUtterance]
    ] = None,
    dialogCodeHook: Option[zio.aws.lexmodelsv2.model.DialogCodeHookSettings] =
      None,
    fulfillmentCodeHook: Option[
      zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings
    ] = None,
    slotPriorities: Option[Iterable[zio.aws.lexmodelsv2.model.SlotPriority]] =
      None,
    intentConfirmationSetting: Option[
      zio.aws.lexmodelsv2.model.IntentConfirmationSetting
    ] = None,
    intentClosingSetting: Option[
      zio.aws.lexmodelsv2.model.IntentClosingSetting
    ] = None,
    inputContexts: Option[Iterable[zio.aws.lexmodelsv2.model.InputContext]] =
      None,
    outputContexts: Option[Iterable[zio.aws.lexmodelsv2.model.OutputContext]] =
      None,
    kendraConfiguration: Option[zio.aws.lexmodelsv2.model.KendraConfiguration] =
      None,
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest = {
    import UpdateIntentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest
      .builder()
      .intentId(Id.unwrap(intentId): java.lang.String)
      .intentName(Name.unwrap(intentName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        parentIntentSignature.map(value =>
          IntentSignature.unwrap(value): java.lang.String
        )
      )(_.parentIntentSignature)
      .optionallyWith(
        sampleUtterances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sampleUtterances)
      .optionallyWith(dialogCodeHook.map(value => value.buildAwsValue()))(
        _.dialogCodeHook
      )
      .optionallyWith(fulfillmentCodeHook.map(value => value.buildAwsValue()))(
        _.fulfillmentCodeHook
      )
      .optionallyWith(
        slotPriorities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.slotPriorities)
      .optionallyWith(
        intentConfirmationSetting.map(value => value.buildAwsValue())
      )(_.intentConfirmationSetting)
      .optionallyWith(intentClosingSetting.map(value => value.buildAwsValue()))(
        _.intentClosingSetting
      )
      .optionallyWith(
        inputContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputContexts)
      .optionallyWith(
        outputContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputContexts)
      .optionallyWith(kendraConfiguration.map(value => value.buildAwsValue()))(
        _.kendraConfiguration
      )
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateIntentRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateIntentRequest.wrap(buildAwsValue())
}
object UpdateIntentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateIntentRequest =
      zio.aws.lexmodelsv2.model.UpdateIntentRequest(
        intentId,
        intentName,
        description.map(value => value),
        parentIntentSignature.map(value => value),
        sampleUtterances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dialogCodeHook.map(value => value.asEditable),
        fulfillmentCodeHook.map(value => value.asEditable),
        slotPriorities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        intentConfirmationSetting.map(value => value.asEditable),
        intentClosingSetting.map(value => value.asEditable),
        inputContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kendraConfiguration.map(value => value.asEditable),
        botId,
        botVersion,
        localeId
      )
    def intentId: Id
    def intentName: Name
    def description: Option[Description]
    def parentIntentSignature: Option[IntentSignature]
    def sampleUtterances
        : Option[List[zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly]]
    def dialogCodeHook
        : Option[zio.aws.lexmodelsv2.model.DialogCodeHookSettings.ReadOnly]
    def fulfillmentCodeHook
        : Option[zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.ReadOnly]
    def slotPriorities
        : Option[List[zio.aws.lexmodelsv2.model.SlotPriority.ReadOnly]]
    def intentConfirmationSetting
        : Option[zio.aws.lexmodelsv2.model.IntentConfirmationSetting.ReadOnly]
    def intentClosingSetting
        : Option[zio.aws.lexmodelsv2.model.IntentClosingSetting.ReadOnly]
    def inputContexts
        : Option[List[zio.aws.lexmodelsv2.model.InputContext.ReadOnly]]
    def outputContexts
        : Option[List[zio.aws.lexmodelsv2.model.OutputContext.ReadOnly]]
    def kendraConfiguration
        : Option[zio.aws.lexmodelsv2.model.KendraConfiguration.ReadOnly]
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def getIntentId: ZIO[Any, Nothing, Id] = ZIO.succeed(intentId)
    def getIntentName: ZIO[Any, Nothing, Name] = ZIO.succeed(intentName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParentIntentSignature: ZIO[Any, AwsError, IntentSignature] =
      AwsError.unwrapOptionField("parentIntentSignature", parentIntentSignature)
    def getSampleUtterances: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly
    ]] = AwsError.unwrapOptionField("sampleUtterances", sampleUtterances)
    def getDialogCodeHook: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.DialogCodeHookSettings.ReadOnly
    ] = AwsError.unwrapOptionField("dialogCodeHook", dialogCodeHook)
    def getFulfillmentCodeHook: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.ReadOnly
    ] = AwsError.unwrapOptionField("fulfillmentCodeHook", fulfillmentCodeHook)
    def getSlotPriorities: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SlotPriority.ReadOnly
    ]] = AwsError.unwrapOptionField("slotPriorities", slotPriorities)
    def getIntentConfirmationSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.IntentConfirmationSetting.ReadOnly
    ] = AwsError.unwrapOptionField(
      "intentConfirmationSetting",
      intentConfirmationSetting
    )
    def getIntentClosingSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.IntentClosingSetting.ReadOnly
    ] = AwsError.unwrapOptionField("intentClosingSetting", intentClosingSetting)
    def getInputContexts: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.InputContext.ReadOnly
    ]] = AwsError.unwrapOptionField("inputContexts", inputContexts)
    def getOutputContexts: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.OutputContext.ReadOnly
    ]] = AwsError.unwrapOptionField("outputContexts", outputContexts)
    def getKendraConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.KendraConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("kendraConfiguration", kendraConfiguration)
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest
  ) extends zio.aws.lexmodelsv2.model.UpdateIntentRequest.ReadOnly {
    override val intentId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.intentId())
    override val intentName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.intentName())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val parentIntentSignature: Option[IntentSignature] = scala
      .Option(impl.parentIntentSignature())
      .map(value => zio.aws.lexmodelsv2.model.primitives.IntentSignature(value))
    override val sampleUtterances
        : Option[List[zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly]] =
      scala
        .Option(impl.sampleUtterances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.SampleUtterance.wrap(item)
          }.toList
        )
    override val dialogCodeHook
        : Option[zio.aws.lexmodelsv2.model.DialogCodeHookSettings.ReadOnly] =
      scala
        .Option(impl.dialogCodeHook())
        .map(value =>
          zio.aws.lexmodelsv2.model.DialogCodeHookSettings.wrap(value)
        )
    override val fulfillmentCodeHook: Option[
      zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.ReadOnly
    ] = scala
      .Option(impl.fulfillmentCodeHook())
      .map(value =>
        zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.wrap(value)
      )
    override val slotPriorities
        : Option[List[zio.aws.lexmodelsv2.model.SlotPriority.ReadOnly]] = scala
      .Option(impl.slotPriorities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.SlotPriority.wrap(item)
        }.toList
      )
    override val intentConfirmationSetting
        : Option[zio.aws.lexmodelsv2.model.IntentConfirmationSetting.ReadOnly] =
      scala
        .Option(impl.intentConfirmationSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.IntentConfirmationSetting.wrap(value)
        )
    override val intentClosingSetting
        : Option[zio.aws.lexmodelsv2.model.IntentClosingSetting.ReadOnly] =
      scala
        .Option(impl.intentClosingSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.IntentClosingSetting.wrap(value)
        )
    override val inputContexts
        : Option[List[zio.aws.lexmodelsv2.model.InputContext.ReadOnly]] = scala
      .Option(impl.inputContexts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.InputContext.wrap(item)
        }.toList
      )
    override val outputContexts
        : Option[List[zio.aws.lexmodelsv2.model.OutputContext.ReadOnly]] = scala
      .Option(impl.outputContexts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.OutputContext.wrap(item)
        }.toList
      )
    override val kendraConfiguration
        : Option[zio.aws.lexmodelsv2.model.KendraConfiguration.ReadOnly] = scala
      .Option(impl.kendraConfiguration())
      .map(value => zio.aws.lexmodelsv2.model.KendraConfiguration.wrap(value))
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest
  ): zio.aws.lexmodelsv2.model.UpdateIntentRequest.ReadOnly = new Wrapper(impl)
}
