package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExportResourceSpecification(
    botExportSpecification: Option[
      zio.aws.lexmodelsv2.model.BotExportSpecification
    ] = None,
    botLocaleExportSpecification: Option[
      zio.aws.lexmodelsv2.model.BotLocaleExportSpecification
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ExportResourceSpecification = {
    import ExportResourceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ExportResourceSpecification
      .builder()
      .optionallyWith(
        botExportSpecification.map(value => value.buildAwsValue())
      )(_.botExportSpecification)
      .optionallyWith(
        botLocaleExportSpecification.map(value => value.buildAwsValue())
      )(_.botLocaleExportSpecification)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.ExportResourceSpecification.wrap(buildAwsValue())
}
object ExportResourceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ExportResourceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ExportResourceSpecification =
      zio.aws.lexmodelsv2.model.ExportResourceSpecification(
        botExportSpecification.map(value => value.asEditable),
        botLocaleExportSpecification.map(value => value.asEditable)
      )
    def botExportSpecification
        : Option[zio.aws.lexmodelsv2.model.BotExportSpecification.ReadOnly]
    def botLocaleExportSpecification: Option[
      zio.aws.lexmodelsv2.model.BotLocaleExportSpecification.ReadOnly
    ]
    def getBotExportSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotExportSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "botExportSpecification",
      botExportSpecification
    )
    def getBotLocaleExportSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotLocaleExportSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "botLocaleExportSpecification",
      botLocaleExportSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ExportResourceSpecification
  ) extends zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly {
    override val botExportSpecification
        : Option[zio.aws.lexmodelsv2.model.BotExportSpecification.ReadOnly] =
      scala
        .Option(impl.botExportSpecification())
        .map(value =>
          zio.aws.lexmodelsv2.model.BotExportSpecification.wrap(value)
        )
    override val botLocaleExportSpecification: Option[
      zio.aws.lexmodelsv2.model.BotLocaleExportSpecification.ReadOnly
    ] = scala
      .Option(impl.botLocaleExportSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.BotLocaleExportSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ExportResourceSpecification
  ): zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly =
    new Wrapper(impl)
}
