package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  NextToken,
  MaxResults,
  BotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListBotLocalesRequest(
    botId: Id,
    botVersion: BotVersion,
    sortBy: Option[zio.aws.lexmodelsv2.model.BotLocaleSortBy] = None,
    filters: Option[Iterable[zio.aws.lexmodelsv2.model.BotLocaleFilter]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest = {
    import ListBotLocalesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(BotVersion.unwrap(botVersion): java.lang.String)
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListBotLocalesRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBotLocalesRequest.wrap(buildAwsValue())
}
object ListBotLocalesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBotLocalesRequest =
      zio.aws.lexmodelsv2.model.ListBotLocalesRequest(
        botId,
        botVersion,
        sortBy.map(value => value.asEditable),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def botId: Id
    def botVersion: BotVersion
    def sortBy: Option[zio.aws.lexmodelsv2.model.BotLocaleSortBy.ReadOnly]
    def filters
        : Option[List[zio.aws.lexmodelsv2.model.BotLocaleFilter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, BotVersion] = ZIO.succeed(botVersion)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotLocaleSortBy.ReadOnly
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotLocaleFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest
  ) extends zio.aws.lexmodelsv2.model.ListBotLocalesRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: BotVersion =
      zio.aws.lexmodelsv2.model.primitives.BotVersion(impl.botVersion())
    override val sortBy
        : Option[zio.aws.lexmodelsv2.model.BotLocaleSortBy.ReadOnly] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.lexmodelsv2.model.BotLocaleSortBy.wrap(value))
    override val filters
        : Option[List[zio.aws.lexmodelsv2.model.BotLocaleFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.BotLocaleFilter.wrap(item)
          }.toList
        )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest
  ): zio.aws.lexmodelsv2.model.ListBotLocalesRequest.ReadOnly = new Wrapper(
    impl
  )
}
