package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  NextToken,
  BotAliasId,
  Timestamp,
  BotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ListAggregatedUtterancesResponse(
    botId: Option[Id] = None,
    botAliasId: Option[BotAliasId] = None,
    botVersion: Option[BotVersion] = None,
    localeId: Option[LocaleId] = None,
    aggregationDuration: Option[
      zio.aws.lexmodelsv2.model.UtteranceAggregationDuration
    ] = None,
    aggregationWindowStartTime: Option[Timestamp] = None,
    aggregationWindowEndTime: Option[Timestamp] = None,
    aggregationLastRefreshedDateTime: Option[Timestamp] = None,
    aggregatedUtterancesSummaries: Option[
      Iterable[zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse = {
    import ListAggregatedUtterancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botAliasId.map(value => BotAliasId.unwrap(value): java.lang.String)
      )(_.botAliasId)
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(aggregationDuration.map(value => value.buildAwsValue()))(
        _.aggregationDuration
      )
      .optionallyWith(
        aggregationWindowStartTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.aggregationWindowStartTime)
      .optionallyWith(
        aggregationWindowEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.aggregationWindowEndTime)
      .optionallyWith(
        aggregationLastRefreshedDateTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.aggregationLastRefreshedDateTime)
      .optionallyWith(
        aggregatedUtterancesSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregatedUtterancesSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse
      .wrap(buildAwsValue())
}
object ListAggregatedUtterancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse =
      zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse(
        botId.map(value => value),
        botAliasId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        aggregationDuration.map(value => value.asEditable),
        aggregationWindowStartTime.map(value => value),
        aggregationWindowEndTime.map(value => value),
        aggregationLastRefreshedDateTime.map(value => value),
        aggregatedUtterancesSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def botId: Option[Id]
    def botAliasId: Option[BotAliasId]
    def botVersion: Option[BotVersion]
    def localeId: Option[LocaleId]
    def aggregationDuration: Option[
      zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.ReadOnly
    ]
    def aggregationWindowStartTime: Option[Timestamp]
    def aggregationWindowEndTime: Option[Timestamp]
    def aggregationLastRefreshedDateTime: Option[Timestamp]
    def aggregatedUtterancesSummaries: Option[
      List[zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotAliasId: ZIO[Any, AwsError, BotAliasId] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getAggregationDuration: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.ReadOnly
    ] = AwsError.unwrapOptionField("aggregationDuration", aggregationDuration)
    def getAggregationWindowStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "aggregationWindowStartTime",
        aggregationWindowStartTime
      )
    def getAggregationWindowEndTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("aggregationWindowEndTime", aggregationWindowEndTime)
    def getAggregationLastRefreshedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "aggregationLastRefreshedDateTime",
        aggregationLastRefreshedDateTime
      )
    def getAggregatedUtterancesSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "aggregatedUtterancesSummaries",
      aggregatedUtterancesSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse
  ) extends zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botAliasId: Option[BotAliasId] = scala
      .Option(impl.botAliasId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotAliasId(value))
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val aggregationDuration: Option[
      zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.ReadOnly
    ] = scala
      .Option(impl.aggregationDuration())
      .map(value =>
        zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.wrap(value)
      )
    override val aggregationWindowStartTime: Option[Timestamp] = scala
      .Option(impl.aggregationWindowStartTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val aggregationWindowEndTime: Option[Timestamp] = scala
      .Option(impl.aggregationWindowEndTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val aggregationLastRefreshedDateTime: Option[Timestamp] = scala
      .Option(impl.aggregationLastRefreshedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val aggregatedUtterancesSummaries: Option[
      List[zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary.ReadOnly]
    ] = scala
      .Option(impl.aggregatedUtterancesSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse
  ): zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse.ReadOnly =
    new Wrapper(impl)
}
