package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait ExportStatus {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus
}
object ExportStatus {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus
  ): zio.aws.lexmodelsv2.model.ExportStatus = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus.DELETING =>
      val r = Deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.lexmodelsv2.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.lexmodelsv2.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus.COMPLETED
  }
  case object Failed extends zio.aws.lexmodelsv2.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus.FAILED
  }
  case object Deleting extends zio.aws.lexmodelsv2.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus.DELETING
  }
}
