package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Timestamp, BotVersion}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class BotAliasHistoryEvent(
    botVersion: Option[BotVersion] = None,
    startDate: Option[Timestamp] = None,
    endDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotAliasHistoryEvent = {
    import BotAliasHistoryEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotAliasHistoryEvent
      .builder()
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(startDate.map(value => Timestamp.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(endDate.map(value => Timestamp.unwrap(value): Instant))(
        _.endDate
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotAliasHistoryEvent.ReadOnly =
    zio.aws.lexmodelsv2.model.BotAliasHistoryEvent.wrap(buildAwsValue())
}
object BotAliasHistoryEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotAliasHistoryEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotAliasHistoryEvent =
      zio.aws.lexmodelsv2.model.BotAliasHistoryEvent(
        botVersion.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value)
      )
    def botVersion: Option[BotVersion]
    def startDate: Option[Timestamp]
    def endDate: Option[Timestamp]
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endDate", endDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotAliasHistoryEvent
  ) extends zio.aws.lexmodelsv2.model.BotAliasHistoryEvent.ReadOnly {
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val startDate: Option[Timestamp] = scala
      .Option(impl.startDate())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val endDate: Option[Timestamp] = scala
      .Option(impl.endDate())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotAliasHistoryEvent
  ): zio.aws.lexmodelsv2.model.BotAliasHistoryEvent.ReadOnly = new Wrapper(impl)
}
