package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{NextToken, DraftBotVersion, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListImportsResponse(
    botId: Option[Id] = None,
    botVersion: Option[DraftBotVersion] = None,
    importSummaries: Option[Iterable[zio.aws.lexmodelsv2.model.ImportSummary]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse = {
    import ListImportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        importSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListImportsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListImportsResponse.wrap(buildAwsValue())
}
object ListImportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListImportsResponse =
      zio.aws.lexmodelsv2.model.ListImportsResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        importSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def botId: Option[Id]
    def botVersion: Option[DraftBotVersion]
    def importSummaries
        : Option[List[zio.aws.lexmodelsv2.model.ImportSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getImportSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.ImportSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("importSummaries", importSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse
  ) extends zio.aws.lexmodelsv2.model.ListImportsResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[DraftBotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val importSummaries
        : Option[List[zio.aws.lexmodelsv2.model.ImportSummary.ReadOnly]] = scala
      .Option(impl.importSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.ImportSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse
  ): zio.aws.lexmodelsv2.model.ListImportsResponse.ReadOnly = new Wrapper(impl)
}
