package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{NextToken, BotVersion, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListExportsResponse(
    botId: Option[Id] = None,
    botVersion: Option[BotVersion] = None,
    exportSummaries: Option[Iterable[zio.aws.lexmodelsv2.model.ExportSummary]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse = {
    import ListExportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        exportSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exportSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListExportsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListExportsResponse.wrap(buildAwsValue())
}
object ListExportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListExportsResponse =
      zio.aws.lexmodelsv2.model.ListExportsResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        exportSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def botId: Option[Id]
    def botVersion: Option[BotVersion]
    def exportSummaries
        : Option[List[zio.aws.lexmodelsv2.model.ExportSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getExportSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.ExportSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("exportSummaries", exportSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse
  ) extends zio.aws.lexmodelsv2.model.ListExportsResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val exportSummaries
        : Option[List[zio.aws.lexmodelsv2.model.ExportSummary.ReadOnly]] = scala
      .Option(impl.exportSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.ExportSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse
  ): zio.aws.lexmodelsv2.model.ListExportsResponse.ReadOnly = new Wrapper(impl)
}
