package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserTurnIntentOutput(
    name: Name,
    slots: Optional[Map[Name, zio.aws.lexmodelsv2.model.UserTurnSlotOutput]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UserTurnIntentOutput = {
    import UserTurnIntentOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UserTurnIntentOutput
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        slots.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.slots)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UserTurnIntentOutput.ReadOnly =
    zio.aws.lexmodelsv2.model.UserTurnIntentOutput.wrap(buildAwsValue())
}
object UserTurnIntentOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UserTurnIntentOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UserTurnIntentOutput =
      zio.aws.lexmodelsv2.model.UserTurnIntentOutput(
        name,
        slots.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def name: Name
    def slots: Optional[
      Map[Name, zio.aws.lexmodelsv2.model.UserTurnSlotOutput.ReadOnly]
    ]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSlots: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.lexmodelsv2.model.UserTurnSlotOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("slots", slots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UserTurnIntentOutput
  ) extends zio.aws.lexmodelsv2.model.UserTurnIntentOutput.ReadOnly {
    override val name: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.name())
    override val slots: Optional[
      Map[Name, zio.aws.lexmodelsv2.model.UserTurnSlotOutput.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.slots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.Name(
              key
            ) -> zio.aws.lexmodelsv2.model.UserTurnSlotOutput.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UserTurnIntentOutput
  ): zio.aws.lexmodelsv2.model.UserTurnIntentOutput.ReadOnly = new Wrapper(impl)
}
