package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Name
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TestSetIntentDiscrepancyItem(
    intentName: Name,
    errorMessage: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TestSetIntentDiscrepancyItem = {
    import TestSetIntentDiscrepancyItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetIntentDiscrepancyItem
      .builder()
      .intentName(Name.unwrap(intentName): java.lang.String)
      .errorMessage(errorMessage: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.TestSetIntentDiscrepancyItem.ReadOnly =
    zio.aws.lexmodelsv2.model.TestSetIntentDiscrepancyItem.wrap(buildAwsValue())
}
object TestSetIntentDiscrepancyItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TestSetIntentDiscrepancyItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TestSetIntentDiscrepancyItem =
      zio.aws.lexmodelsv2.model
        .TestSetIntentDiscrepancyItem(intentName, errorMessage)
    def intentName: Name
    def errorMessage: String
    def getIntentName: ZIO[Any, Nothing, Name] = ZIO.succeed(intentName)
    def getErrorMessage: ZIO[Any, Nothing, String] = ZIO.succeed(errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetIntentDiscrepancyItem
  ) extends zio.aws.lexmodelsv2.model.TestSetIntentDiscrepancyItem.ReadOnly {
    override val intentName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.intentName())
    override val errorMessage: String = impl.errorMessage(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TestSetIntentDiscrepancyItem
  ): zio.aws.lexmodelsv2.model.TestSetIntentDiscrepancyItem.ReadOnly =
    new Wrapper(impl)
}
