package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  NextToken,
  LocaleId,
  BotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListIntentsResponse(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    intentSummaries: Optional[
      Iterable[zio.aws.lexmodelsv2.model.IntentSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse = {
    import ListIntentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        intentSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.intentSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListIntentsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListIntentsResponse.wrap(buildAwsValue())
}
object ListIntentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListIntentsResponse =
      zio.aws.lexmodelsv2.model.ListIntentsResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        intentSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def botId: Optional[Id]
    def botVersion: Optional[BotVersion]
    def localeId: Optional[LocaleId]
    def intentSummaries
        : Optional[List[zio.aws.lexmodelsv2.model.IntentSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getIntentSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.IntentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("intentSummaries", intentSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse
  ) extends zio.aws.lexmodelsv2.model.ListIntentsResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val intentSummaries
        : Optional[List[zio.aws.lexmodelsv2.model.IntentSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intentSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.IntentSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse
  ): zio.aws.lexmodelsv2.model.ListIntentsResponse.ReadOnly = new Wrapper(impl)
}
