package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{AnalyticsPath, Timestamp, Id}
import scala.jdk.CollectionConverters._
final case class ListIntentPathsRequest(
    botId: Id,
    startDateTime: Timestamp,
    endDateTime: Timestamp,
    intentPath: AnalyticsPath,
    filters: Optional[Iterable[zio.aws.lexmodelsv2.model.AnalyticsPathFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsRequest = {
    import ListIntentPathsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .startDateTime(Timestamp.unwrap(startDateTime): Instant)
      .endDateTime(Timestamp.unwrap(endDateTime): Instant)
      .intentPath(AnalyticsPath.unwrap(intentPath): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListIntentPathsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListIntentPathsRequest.wrap(buildAwsValue())
}
object ListIntentPathsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListIntentPathsRequest =
      zio.aws.lexmodelsv2.model.ListIntentPathsRequest(
        botId,
        startDateTime,
        endDateTime,
        intentPath,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def botId: Id
    def startDateTime: Timestamp
    def endDateTime: Timestamp
    def intentPath: AnalyticsPath
    def filters
        : Optional[List[zio.aws.lexmodelsv2.model.AnalyticsPathFilter.ReadOnly]]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getStartDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(startDateTime)
    def getEndDateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDateTime)
    def getIntentPath: ZIO[Any, Nothing, AnalyticsPath] =
      ZIO.succeed(intentPath)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsPathFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsRequest
  ) extends zio.aws.lexmodelsv2.model.ListIntentPathsRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val startDateTime: Timestamp =
      zio.aws.lexmodelsv2.model.primitives.Timestamp(impl.startDateTime())
    override val endDateTime: Timestamp =
      zio.aws.lexmodelsv2.model.primitives.Timestamp(impl.endDateTime())
    override val intentPath: AnalyticsPath =
      zio.aws.lexmodelsv2.model.primitives.AnalyticsPath(impl.intentPath())
    override val filters: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsPathFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsPathFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsRequest
  ): zio.aws.lexmodelsv2.model.ListIntentPathsRequest.ReadOnly = new Wrapper(
    impl
  )
}
