package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait IntentState {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.IntentState
}
object IntentState {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.IntentState
  ): zio.aws.lexmodelsv2.model.IntentState = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.IntentState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.IntentState.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.IntentState.FULFILLED =>
      val r = Fulfilled
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.IntentState.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.IntentState.READY_FOR_FULFILLMENT =>
      val r = ReadyForFulfillment
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.IntentState.WAITING =>
      val r = Waiting
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.IntentState.FULFILLMENT_IN_PROGRESS =>
      val r = FulfillmentInProgress
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.IntentState {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.IntentState =
      software.amazon.awssdk.services.lexmodelsv2.model.IntentState.UNKNOWN_TO_SDK_VERSION
  }
  case object Failed extends zio.aws.lexmodelsv2.model.IntentState {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.IntentState =
      software.amazon.awssdk.services.lexmodelsv2.model.IntentState.FAILED
  }
  case object Fulfilled extends zio.aws.lexmodelsv2.model.IntentState {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.IntentState =
      software.amazon.awssdk.services.lexmodelsv2.model.IntentState.FULFILLED
  }
  case object InProgress extends zio.aws.lexmodelsv2.model.IntentState {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.IntentState =
      software.amazon.awssdk.services.lexmodelsv2.model.IntentState.IN_PROGRESS
  }
  case object ReadyForFulfillment
      extends zio.aws.lexmodelsv2.model.IntentState {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.IntentState =
      software.amazon.awssdk.services.lexmodelsv2.model.IntentState.READY_FOR_FULFILLMENT
  }
  case object Waiting extends zio.aws.lexmodelsv2.model.IntentState {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.IntentState =
      software.amazon.awssdk.services.lexmodelsv2.model.IntentState.WAITING
  }
  case object FulfillmentInProgress
      extends zio.aws.lexmodelsv2.model.IntentState {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.IntentState =
      software.amazon.awssdk.services.lexmodelsv2.model.IntentState.FULFILLMENT_IN_PROGRESS
  }
}
