package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.Count
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class IntentClassificationTestResultItemCounts(
    totalResultCount: Count,
    speechTranscriptionResultCounts: Optional[
      Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count]
    ] = Optional.Absent,
    intentMatchResultCounts: Map[
      zio.aws.lexmodelsv2.model.TestResultMatchStatus,
      Count
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResultItemCounts = {
    import IntentClassificationTestResultItemCounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResultItemCounts
      .builder()
      .totalResultCount(Count.unwrap(totalResultCount): Integer)
      .optionallyWith(
        speechTranscriptionResultCounts.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (Count.unwrap(value): Integer)
            })
            .asJava
        )
      )(_.speechTranscriptionResultCountsWithStrings)
      .intentMatchResultCountsWithStrings(
        intentMatchResultCounts
          .map({ case (key, value) =>
            key.unwrap.toString -> (Count.unwrap(value): Integer)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.IntentClassificationTestResultItemCounts.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentClassificationTestResultItemCounts
      .wrap(buildAwsValue())
}
object IntentClassificationTestResultItemCounts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResultItemCounts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.IntentClassificationTestResultItemCounts =
      zio.aws.lexmodelsv2.model.IntentClassificationTestResultItemCounts(
        totalResultCount,
        speechTranscriptionResultCounts.map(value => value),
        intentMatchResultCounts
      )
    def totalResultCount: Count
    def speechTranscriptionResultCounts
        : Optional[Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count]]
    def intentMatchResultCounts
        : Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count]
    def getTotalResultCount: ZIO[Any, Nothing, Count] =
      ZIO.succeed(totalResultCount)
    def getSpeechTranscriptionResultCounts: ZIO[Any, AwsError, Map[
      zio.aws.lexmodelsv2.model.TestResultMatchStatus,
      Count
    ]] = AwsError.unwrapOptionField(
      "speechTranscriptionResultCounts",
      speechTranscriptionResultCounts
    )
    def getIntentMatchResultCounts: ZIO[Any, Nothing, Map[
      zio.aws.lexmodelsv2.model.TestResultMatchStatus,
      Count
    ]] = ZIO.succeed(intentMatchResultCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResultItemCounts
  ) extends zio.aws.lexmodelsv2.model.IntentClassificationTestResultItemCounts.ReadOnly {
    override val totalResultCount: Count =
      zio.aws.lexmodelsv2.model.primitives.Count(impl.totalResultCount())
    override val speechTranscriptionResultCounts: Optional[
      Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.speechTranscriptionResultCounts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.TestResultMatchStatus
              .wrap(key) -> zio.aws.lexmodelsv2.model.primitives.Count(value)
          })
          .toMap
      )
    override val intentMatchResultCounts
        : Map[zio.aws.lexmodelsv2.model.TestResultMatchStatus, Count] = impl
      .intentMatchResultCounts()
      .asScala
      .map({ case (key, value) =>
        zio.aws.lexmodelsv2.model.TestResultMatchStatus
          .wrap(key) -> zio.aws.lexmodelsv2.model.primitives.Count(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentClassificationTestResultItemCounts
  ): zio.aws.lexmodelsv2.model.IntentClassificationTestResultItemCounts.ReadOnly =
    new Wrapper(impl)
}
