package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InvokedIntentSample(
    intentName: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.InvokedIntentSample = {
    import InvokedIntentSample.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.InvokedIntentSample
      .builder()
      .optionallyWith(
        intentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.intentName)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.InvokedIntentSample.ReadOnly =
    zio.aws.lexmodelsv2.model.InvokedIntentSample.wrap(buildAwsValue())
}
object InvokedIntentSample {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.InvokedIntentSample
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.InvokedIntentSample =
      zio.aws.lexmodelsv2.model
        .InvokedIntentSample(intentName.map(value => value))
    def intentName: Optional[Name]
    def getIntentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("intentName", intentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.InvokedIntentSample
  ) extends zio.aws.lexmodelsv2.model.InvokedIntentSample.ReadOnly {
    override val intentName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.intentName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.InvokedIntentSample
  ): zio.aws.lexmodelsv2.model.InvokedIntentSample.ReadOnly = new Wrapper(impl)
}
