package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.AnalyticsBinValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnalyticsBinKey(
    name: Optional[zio.aws.lexmodelsv2.model.AnalyticsBinByName] =
      Optional.Absent,
    value: Optional[AnalyticsBinValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey = {
    import AnalyticsBinKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value => AnalyticsBinValue.unwrap(value): java.lang.Long)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly =
    zio.aws.lexmodelsv2.model.AnalyticsBinKey.wrap(buildAwsValue())
}
object AnalyticsBinKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AnalyticsBinKey =
      zio.aws.lexmodelsv2.model
        .AnalyticsBinKey(name.map(value => value), value.map(value => value))
    def name: Optional[zio.aws.lexmodelsv2.model.AnalyticsBinByName]
    def value: Optional[AnalyticsBinValue]
    def getName
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.AnalyticsBinByName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, AnalyticsBinValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey
  ) extends zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly {
    override val name: Optional[zio.aws.lexmodelsv2.model.AnalyticsBinByName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.lexmodelsv2.model.AnalyticsBinByName.wrap(value))
    override val value: Optional[AnalyticsBinValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.AnalyticsBinValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey
  ): zio.aws.lexmodelsv2.model.AnalyticsBinKey.ReadOnly = new Wrapper(impl)
}
