package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserTurnResult(
    input: zio.aws.lexmodelsv2.model.UserTurnInputSpecification,
    expectedOutput: zio.aws.lexmodelsv2.model.UserTurnOutputSpecification,
    actualOutput: Optional[
      zio.aws.lexmodelsv2.model.UserTurnOutputSpecification
    ] = Optional.Absent,
    errorDetails: Optional[zio.aws.lexmodelsv2.model.ExecutionErrorDetails] =
      Optional.Absent,
    endToEndResult: Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      Optional.Absent,
    intentMatchResult: Optional[
      zio.aws.lexmodelsv2.model.TestResultMatchStatus
    ] = Optional.Absent,
    slotMatchResult: Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      Optional.Absent,
    speechTranscriptionResult: Optional[
      zio.aws.lexmodelsv2.model.TestResultMatchStatus
    ] = Optional.Absent,
    conversationLevelResult: Optional[
      zio.aws.lexmodelsv2.model.ConversationLevelResultDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UserTurnResult = {
    import UserTurnResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UserTurnResult
      .builder()
      .input(input.buildAwsValue())
      .expectedOutput(expectedOutput.buildAwsValue())
      .optionallyWith(actualOutput.map(value => value.buildAwsValue()))(
        _.actualOutput
      )
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .optionallyWith(endToEndResult.map(value => value.unwrap))(
        _.endToEndResult
      )
      .optionallyWith(intentMatchResult.map(value => value.unwrap))(
        _.intentMatchResult
      )
      .optionallyWith(slotMatchResult.map(value => value.unwrap))(
        _.slotMatchResult
      )
      .optionallyWith(speechTranscriptionResult.map(value => value.unwrap))(
        _.speechTranscriptionResult
      )
      .optionallyWith(
        conversationLevelResult.map(value => value.buildAwsValue())
      )(_.conversationLevelResult)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UserTurnResult.ReadOnly =
    zio.aws.lexmodelsv2.model.UserTurnResult.wrap(buildAwsValue())
}
object UserTurnResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UserTurnResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UserTurnResult =
      zio.aws.lexmodelsv2.model.UserTurnResult(
        input.asEditable,
        expectedOutput.asEditable,
        actualOutput.map(value => value.asEditable),
        errorDetails.map(value => value.asEditable),
        endToEndResult.map(value => value),
        intentMatchResult.map(value => value),
        slotMatchResult.map(value => value),
        speechTranscriptionResult.map(value => value),
        conversationLevelResult.map(value => value.asEditable)
      )
    def input: zio.aws.lexmodelsv2.model.UserTurnInputSpecification.ReadOnly
    def expectedOutput
        : zio.aws.lexmodelsv2.model.UserTurnOutputSpecification.ReadOnly
    def actualOutput: Optional[
      zio.aws.lexmodelsv2.model.UserTurnOutputSpecification.ReadOnly
    ]
    def errorDetails
        : Optional[zio.aws.lexmodelsv2.model.ExecutionErrorDetails.ReadOnly]
    def endToEndResult
        : Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus]
    def intentMatchResult
        : Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus]
    def slotMatchResult
        : Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus]
    def speechTranscriptionResult
        : Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus]
    def conversationLevelResult: Optional[
      zio.aws.lexmodelsv2.model.ConversationLevelResultDetail.ReadOnly
    ]
    def getInput: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.UserTurnInputSpecification.ReadOnly
    ] = ZIO.succeed(input)
    def getExpectedOutput: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.UserTurnOutputSpecification.ReadOnly
    ] = ZIO.succeed(expectedOutput)
    def getActualOutput: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.UserTurnOutputSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("actualOutput", actualOutput)
    def getErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ExecutionErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("errorDetails", errorDetails)
    def getEndToEndResult
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      AwsError.unwrapOptionField("endToEndResult", endToEndResult)
    def getIntentMatchResult
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      AwsError.unwrapOptionField("intentMatchResult", intentMatchResult)
    def getSlotMatchResult
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      AwsError.unwrapOptionField("slotMatchResult", slotMatchResult)
    def getSpeechTranscriptionResult
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      AwsError.unwrapOptionField(
        "speechTranscriptionResult",
        speechTranscriptionResult
      )
    def getConversationLevelResult: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConversationLevelResultDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "conversationLevelResult",
      conversationLevelResult
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UserTurnResult
  ) extends zio.aws.lexmodelsv2.model.UserTurnResult.ReadOnly {
    override val input
        : zio.aws.lexmodelsv2.model.UserTurnInputSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.UserTurnInputSpecification.wrap(impl.input())
    override val expectedOutput
        : zio.aws.lexmodelsv2.model.UserTurnOutputSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.UserTurnOutputSpecification
        .wrap(impl.expectedOutput())
    override val actualOutput: Optional[
      zio.aws.lexmodelsv2.model.UserTurnOutputSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.actualOutput())
      .map(value =>
        zio.aws.lexmodelsv2.model.UserTurnOutputSpecification.wrap(value)
      )
    override val errorDetails
        : Optional[zio.aws.lexmodelsv2.model.ExecutionErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorDetails())
        .map(value =>
          zio.aws.lexmodelsv2.model.ExecutionErrorDetails.wrap(value)
        )
    override val endToEndResult
        : Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endToEndResult())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestResultMatchStatus.wrap(value)
        )
    override val intentMatchResult
        : Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intentMatchResult())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestResultMatchStatus.wrap(value)
        )
    override val slotMatchResult
        : Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slotMatchResult())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestResultMatchStatus.wrap(value)
        )
    override val speechTranscriptionResult
        : Optional[zio.aws.lexmodelsv2.model.TestResultMatchStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.speechTranscriptionResult())
        .map(value =>
          zio.aws.lexmodelsv2.model.TestResultMatchStatus.wrap(value)
        )
    override val conversationLevelResult: Optional[
      zio.aws.lexmodelsv2.model.ConversationLevelResultDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conversationLevelResult())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConversationLevelResultDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UserTurnResult
  ): zio.aws.lexmodelsv2.model.UserTurnResult.ReadOnly = new Wrapper(impl)
}
