package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.ObjectPrefix
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PathFormat(
    objectPrefixes: Optional[Iterable[ObjectPrefix]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.PathFormat = {
    import PathFormat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.PathFormat
      .builder()
      .optionallyWith(
        objectPrefixes.map(value =>
          value.map { item =>
            ObjectPrefix.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.objectPrefixes)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.PathFormat.ReadOnly =
    zio.aws.lexmodelsv2.model.PathFormat.wrap(buildAwsValue())
}
object PathFormat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.PathFormat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.PathFormat =
      zio.aws.lexmodelsv2.model.PathFormat(objectPrefixes.map(value => value))
    def objectPrefixes: Optional[List[ObjectPrefix]]
    def getObjectPrefixes: ZIO[Any, AwsError, List[ObjectPrefix]] =
      AwsError.unwrapOptionField("objectPrefixes", objectPrefixes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PathFormat
  ) extends zio.aws.lexmodelsv2.model.PathFormat.ReadOnly {
    override val objectPrefixes: Optional[List[ObjectPrefix]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectPrefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.primitives.ObjectPrefix(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PathFormat
  ): zio.aws.lexmodelsv2.model.PathFormat.ReadOnly = new Wrapper(impl)
}
