package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  NextToken,
  MaxResults,
  Timestamp,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListUtteranceAnalyticsDataRequest(
    botId: Id,
    startDateTime: Timestamp,
    endDateTime: Timestamp,
    sortBy: Optional[zio.aws.lexmodelsv2.model.UtteranceDataSortBy] =
      Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AnalyticsUtteranceFilter]
    ] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest = {
    import ListUtteranceAnalyticsDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .startDateTime(Timestamp.unwrap(startDateTime): Instant)
      .endDateTime(Timestamp.unwrap(endDateTime): Instant)
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest
      .wrap(buildAwsValue())
}
object ListUtteranceAnalyticsDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest =
      zio.aws.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest(
        botId,
        startDateTime,
        endDateTime,
        sortBy.map(value => value.asEditable),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def botId: Id
    def startDateTime: Timestamp
    def endDateTime: Timestamp
    def sortBy: Optional[zio.aws.lexmodelsv2.model.UtteranceDataSortBy.ReadOnly]
    def filters: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsUtteranceFilter.ReadOnly]
    ]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getStartDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(startDateTime)
    def getEndDateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDateTime)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.UtteranceDataSortBy.ReadOnly
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AnalyticsUtteranceFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest
  ) extends zio.aws.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val startDateTime: Timestamp =
      zio.aws.lexmodelsv2.model.primitives.Timestamp(impl.startDateTime())
    override val endDateTime: Timestamp =
      zio.aws.lexmodelsv2.model.primitives.Timestamp(impl.endDateTime())
    override val sortBy
        : Optional[zio.aws.lexmodelsv2.model.UtteranceDataSortBy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.lexmodelsv2.model.UtteranceDataSortBy.wrap(value))
    override val filters: Optional[
      List[zio.aws.lexmodelsv2.model.AnalyticsUtteranceFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AnalyticsUtteranceFilter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest
  ): zio.aws.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest.ReadOnly =
    new Wrapper(impl)
}
